/*
 * Decompiled with CFR 0.152.
 */
package azkaban;

import azkaban.AzkabanCommonModuleConfig;
import azkaban.AzkabanCoreModule;
import azkaban.HadoopModule;
import azkaban.db.AzkabanDataSource;
import azkaban.db.H2FileDataSource;
import azkaban.db.MySQLDataSource;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.JdbcExecutorLoader;
import azkaban.project.JdbcProjectImpl;
import azkaban.project.ProjectLoader;
import azkaban.spi.Storage;
import azkaban.spi.StorageException;
import azkaban.storage.StorageImplementationType;
import azkaban.trigger.JdbcTriggerImpl;
import azkaban.trigger.TriggerLoader;
import azkaban.utils.Props;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzkabanCommonModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(AzkabanCommonModule.class);
    private final Props props;
    private final AzkabanCommonModuleConfig config;

    public AzkabanCommonModule(Props props) {
        this.props = props;
        this.config = new AzkabanCommonModuleConfig(props);
    }

    protected void configure() {
        this.install((Module)new AzkabanCoreModule(this.props));
        this.bind(Storage.class).to(this.resolveStorageClassType());
        this.bind(AzkabanDataSource.class).to(this.resolveDataSourceType());
        this.bind(TriggerLoader.class).to(JdbcTriggerImpl.class);
        this.bind(ProjectLoader.class).to(JdbcProjectImpl.class);
        this.bind(ExecutorLoader.class).to(JdbcExecutorLoader.class);
    }

    public Class<? extends Storage> resolveStorageClassType() {
        StorageImplementationType type = StorageImplementationType.from(this.config.getStorageImplementation());
        if (type == StorageImplementationType.HDFS) {
            this.install((Module)new HadoopModule(this.props));
        }
        if (type != null) {
            return type.getImplementationClass();
        }
        return this.loadCustomStorageClass(this.config.getStorageImplementation());
    }

    private Class<? extends Storage> loadCustomStorageClass(String storageImplementation) {
        try {
            return Class.forName(storageImplementation);
        }
        catch (ClassNotFoundException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private Class<? extends AzkabanDataSource> resolveDataSourceType() {
        String databaseType = this.props.getString("database.type");
        if (databaseType.equals("h2")) {
            return H2FileDataSource.class;
        }
        return MySQLDataSource.class;
    }

    @Provides
    public QueryRunner createQueryRunner(AzkabanDataSource dataSource) {
        return new QueryRunner((DataSource)dataSource);
    }
}

