/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.Executor;

public class ExecutionReference {
    private final int execId;
    private Executor executor;
    private long updateTime;
    private long nextCheckTime = -1L;
    private int numErrors = 0;

    public ExecutionReference(int execId) {
        this.execId = execId;
    }

    public ExecutionReference(int execId, Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Executor cannot be null for exec id: %d ExecutionReference", execId));
        }
        this.execId = execId;
        this.executor = executor;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public long getNextCheckTime() {
        return this.nextCheckTime;
    }

    public void setNextCheckTime(long nextCheckTime) {
        this.nextCheckTime = nextCheckTime;
    }

    public int getExecId() {
        return this.execId;
    }

    public String getHost() {
        return this.executor.getHost();
    }

    public int getPort() {
        return this.executor.getPort();
    }

    public int getNumErrors() {
        return this.numErrors;
    }

    public void setNumErrors(int numErrors) {
        this.numErrors = numErrors;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }
}

