/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.db.DatabaseOperator;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorLogEvent;
import azkaban.executor.ExecutorManagerException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.dbutils.ResultSetHandler;

@Singleton
public class ExecutorEventsDao {
    private final DatabaseOperator dbOperator;

    @Inject
    public ExecutorEventsDao(DatabaseOperator dbOperator) {
        this.dbOperator = dbOperator;
    }

    public void postExecutorEvent(Executor executor, ExecutorLogEvent.EventType type, String user, String message) throws ExecutorManagerException {
        String INSERT_PROJECT_EVENTS = "INSERT INTO executor_events (executor_id, event_type, event_time, username, message) values (?,?,?,?,?)";
        try {
            this.dbOperator.update("INSERT INTO executor_events (executor_id, event_type, event_time, username, message) values (?,?,?,?,?)", new Object[]{executor.getId(), type.getNumVal(), new Date(), user, message});
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Failed to post executor event", e);
        }
    }

    public List<ExecutorLogEvent> getExecutorEvents(Executor executor, int num, int offset) throws ExecutorManagerException {
        try {
            return (List)this.dbOperator.query("SELECT executor_id, event_type, event_time, username, message FROM executor_events  WHERE executor_id=? ORDER BY event_time LIMIT ? OFFSET ?", (ResultSetHandler)new ExecutorLogsResultHandler(), new Object[]{executor.getId(), num, offset});
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Failed to fetch events for executor id : " + executor.getId(), e);
        }
    }

    private static class ExecutorLogsResultHandler
    implements ResultSetHandler<List<ExecutorLogEvent>> {
        private static final String SELECT_EXECUTOR_EVENTS_ORDER = "SELECT executor_id, event_type, event_time, username, message FROM executor_events  WHERE executor_id=? ORDER BY event_time LIMIT ? OFFSET ?";

        private ExecutorLogsResultHandler() {
        }

        public List<ExecutorLogEvent> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<ExecutorLogEvent> events = new ArrayList<ExecutorLogEvent>();
            do {
                int executorId = rs.getInt(1);
                int eventType = rs.getInt(2);
                java.sql.Date eventTime = rs.getDate(3);
                String username = rs.getString(4);
                String message = rs.getString(5);
                ExecutorLogEvent event = new ExecutorLogEvent(executorId, username, eventTime, ExecutorLogEvent.EventType.fromInteger(eventType), message);
                events.add(event);
            } while (rs.next());
            return events;
        }
    }
}

