/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import java.io.Serializable;

public class ExecutorInfo
implements Serializable {
    private static final long serialVersionUID = 3009746603773371263L;
    private double remainingMemoryPercent;
    private long remainingMemoryInMB;
    private int remainingFlowCapacity;
    private int numberOfAssignedFlows;
    private long lastDispatchedTime;
    private double cpuUsage;

    public ExecutorInfo() {
    }

    public ExecutorInfo(double remainingMemoryPercent, long remainingMemory, int remainingFlowCapacity, long lastDispatched, double cpuUsage, int numberOfAssignedFlows) {
        this.remainingMemoryInMB = remainingMemory;
        this.cpuUsage = cpuUsage;
        this.remainingFlowCapacity = remainingFlowCapacity;
        this.remainingMemoryPercent = remainingMemoryPercent;
        this.lastDispatchedTime = lastDispatched;
        this.numberOfAssignedFlows = numberOfAssignedFlows;
    }

    public double getCpuUsage() {
        return this.cpuUsage;
    }

    public void setCpuUpsage(double value) {
        this.cpuUsage = value;
    }

    public double getRemainingMemoryPercent() {
        return this.remainingMemoryPercent;
    }

    public void setRemainingMemoryPercent(double value) {
        this.remainingMemoryPercent = value;
    }

    public long getRemainingMemoryInMB() {
        return this.remainingMemoryInMB;
    }

    public void setRemainingMemoryInMB(long value) {
        this.remainingMemoryInMB = value;
    }

    public int getRemainingFlowCapacity() {
        return this.remainingFlowCapacity;
    }

    public void setRemainingFlowCapacity(int value) {
        this.remainingFlowCapacity = value;
    }

    public long getLastDispatchedTime() {
        return this.lastDispatchedTime;
    }

    public void setLastDispatchedTime(long value) {
        this.lastDispatchedTime = value;
    }

    public int getNumberOfAssignedFlows() {
        return this.numberOfAssignedFlows;
    }

    public void setNumberOfAssignedFlows(int value) {
        this.numberOfAssignedFlows = value;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.remainingMemoryPercent);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.remainingMemoryInMB ^ this.remainingMemoryInMB >>> 32);
        result = 31 * result + this.remainingFlowCapacity;
        result = 31 * result + this.numberOfAssignedFlows;
        result = 31 * result + (int)(this.lastDispatchedTime ^ this.lastDispatchedTime >>> 32);
        temp = Double.doubleToLongBits(this.cpuUsage);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExecutorInfo) {
            boolean result = true;
            ExecutorInfo stat = (ExecutorInfo)obj;
            result &= this.remainingMemoryInMB == stat.remainingMemoryInMB;
            result &= this.cpuUsage == stat.cpuUsage;
            result &= this.remainingFlowCapacity == stat.remainingFlowCapacity;
            result &= this.remainingMemoryPercent == stat.remainingMemoryPercent;
            result &= this.numberOfAssignedFlows == stat.numberOfAssignedFlows;
            return result &= this.lastDispatchedTime == stat.lastDispatchedTime;
        }
        return false;
    }

    public String toString() {
        return "ExecutorInfo{remainingMemoryPercent=" + this.remainingMemoryPercent + ", remainingMemoryInMB=" + this.remainingMemoryInMB + ", remainingFlowCapacity=" + this.remainingFlowCapacity + ", numberOfAssignedFlows=" + this.numberOfAssignedFlows + ", lastDispatchedTime=" + this.lastDispatchedTime + ", cpuUsage=" + this.cpuUsage + '}';
    }
}

