/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableJobInfo;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.project.Project;
import azkaban.utils.FileIOUtils;
import azkaban.utils.Pair;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ExecutorManagerAdapter {
    public boolean isFlowRunning(int var1, String var2);

    public ExecutableFlow getExecutableFlow(int var1) throws ExecutorManagerException;

    public List<Integer> getRunningFlows(int var1, String var2);

    public List<ExecutableFlow> getRunningFlows() throws IOException;

    public List<Pair<ExecutableFlow, Executor>> getActiveFlowsWithExecutor() throws IOException;

    public List<ExecutableFlow> getRecentlyFinishedFlows();

    public List<ExecutableFlow> getExecutableFlows(Project var1, String var2, int var3, int var4) throws ExecutorManagerException;

    public List<ExecutableFlow> getExecutableFlows(int var1, int var2) throws ExecutorManagerException;

    public List<ExecutableFlow> getExecutableFlows(String var1, int var2, int var3) throws ExecutorManagerException;

    public List<ExecutableFlow> getExecutableFlows(String var1, String var2, String var3, int var4, long var5, long var7, int var9, int var10) throws ExecutorManagerException;

    public int getExecutableFlows(int var1, String var2, int var3, int var4, List<ExecutableFlow> var5) throws ExecutorManagerException;

    public List<ExecutableFlow> getExecutableFlows(int var1, String var2, int var3, int var4, Status var5) throws ExecutorManagerException;

    public List<ExecutableJobInfo> getExecutableJobs(Project var1, String var2, int var3, int var4) throws ExecutorManagerException;

    public int getNumberOfJobExecutions(Project var1, String var2) throws ExecutorManagerException;

    public int getNumberOfExecutions(Project var1, String var2) throws ExecutorManagerException;

    public FileIOUtils.LogData getExecutableFlowLog(ExecutableFlow var1, int var2, int var3) throws ExecutorManagerException;

    public FileIOUtils.LogData getExecutionJobLog(ExecutableFlow var1, String var2, int var3, int var4, int var5) throws ExecutorManagerException;

    public List<Object> getExecutionJobStats(ExecutableFlow var1, String var2, int var3) throws ExecutorManagerException;

    public String getJobLinkUrl(ExecutableFlow var1, String var2, int var3);

    public FileIOUtils.JobMetaData getExecutionJobMetaData(ExecutableFlow var1, String var2, int var3, int var4, int var5) throws ExecutorManagerException;

    public void cancelFlow(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public void resumeFlow(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public void pauseFlow(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public void pauseExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public void resumeExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public void retryFailures(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public void retryExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public void disableExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public void enableExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public void cancelExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public String submitExecutableFlow(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public Map<String, Object> callExecutorStats(int var1, String var2, Pair<String, String> ... var3) throws IOException, ExecutorManagerException;

    public Map<String, Object> callExecutorJMX(String var1, String var2, String var3) throws IOException;

    public void shutdown();

    public Set<String> getAllActiveExecutorServerHosts();

    public Thread.State getExecutorManagerThreadState();

    public boolean isExecutorManagerThreadActive();

    public long getLastExecutorManagerThreadCheckTime();

    public Set<? extends String> getPrimaryServerHosts();

    public Collection<Executor> getAllActiveExecutors();

    public Executor fetchExecutor(int var1) throws ExecutorManagerException;

    public void setupExecutors() throws ExecutorManagerException;

    public void enableQueueProcessorThread() throws ExecutorManagerException;

    public void disableQueueProcessorThread() throws ExecutorManagerException;
}

