/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ActiveExecutingFlowsDao;
import azkaban.executor.AssignExecutorDao;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableJobInfo;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionFlowDao;
import azkaban.executor.ExecutionJobDao;
import azkaban.executor.ExecutionLogsDao;
import azkaban.executor.ExecutionReference;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorDao;
import azkaban.executor.ExecutorEventsDao;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorLogEvent;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.FetchActiveFlowDao;
import azkaban.executor.NumExecutionsDao;
import azkaban.executor.Status;
import azkaban.utils.FileIOUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class JdbcExecutorLoader
implements ExecutorLoader {
    private final ExecutionFlowDao executionFlowDao;
    private final ExecutorDao executorDao;
    private final ExecutionJobDao executionJobDao;
    private final ExecutionLogsDao executionLogsDao;
    private final ExecutorEventsDao executorEventsDao;
    private final ActiveExecutingFlowsDao activeExecutingFlowsDao;
    private final FetchActiveFlowDao fetchActiveFlowDao;
    private final AssignExecutorDao assignExecutorDao;
    private final NumExecutionsDao numExecutionsDao;

    @Inject
    public JdbcExecutorLoader(ExecutionFlowDao executionFlowDao, ExecutorDao executorDao, ExecutionJobDao executionJobDao, ExecutionLogsDao executionLogsDao, ExecutorEventsDao executorEventsDao, ActiveExecutingFlowsDao activeExecutingFlowsDao, FetchActiveFlowDao fetchActiveFlowDao, AssignExecutorDao assignExecutorDao, NumExecutionsDao numExecutionsDao) {
        this.executionFlowDao = executionFlowDao;
        this.executorDao = executorDao;
        this.executionJobDao = executionJobDao;
        this.executionLogsDao = executionLogsDao;
        this.executorEventsDao = executorEventsDao;
        this.activeExecutingFlowsDao = activeExecutingFlowsDao;
        this.fetchActiveFlowDao = fetchActiveFlowDao;
        this.numExecutionsDao = numExecutionsDao;
        this.assignExecutorDao = assignExecutorDao;
    }

    @Override
    public synchronized void uploadExecutableFlow(ExecutableFlow flow) throws ExecutorManagerException {
        this.executionFlowDao.uploadExecutableFlow(flow);
    }

    @Override
    public void updateExecutableFlow(ExecutableFlow flow) throws ExecutorManagerException {
        this.executionFlowDao.updateExecutableFlow(flow);
    }

    @Override
    public ExecutableFlow fetchExecutableFlow(int id) throws ExecutorManagerException {
        return this.executionFlowDao.fetchExecutableFlow(id);
    }

    @Override
    public List<Pair<ExecutionReference, ExecutableFlow>> fetchQueuedFlows() throws ExecutorManagerException {
        return this.executionFlowDao.fetchQueuedFlows();
    }

    @Override
    public List<ExecutableFlow> fetchRecentlyFinishedFlows(Duration maxAge) throws ExecutorManagerException {
        return this.executionFlowDao.fetchRecentlyFinishedFlows(maxAge);
    }

    @Override
    public Map<Integer, Pair<ExecutionReference, ExecutableFlow>> fetchActiveFlows() throws ExecutorManagerException {
        return this.fetchActiveFlowDao.fetchActiveFlows();
    }

    @Override
    public Pair<ExecutionReference, ExecutableFlow> fetchActiveFlowByExecId(int execId) throws ExecutorManagerException {
        return this.fetchActiveFlowDao.fetchActiveFlowByExecId(execId);
    }

    @Override
    public int fetchNumExecutableFlows() throws ExecutorManagerException {
        return this.numExecutionsDao.fetchNumExecutableFlows();
    }

    @Override
    public int fetchNumExecutableFlows(int projectId, String flowId) throws ExecutorManagerException {
        return this.numExecutionsDao.fetchNumExecutableFlows(projectId, flowId);
    }

    @Override
    public int fetchNumExecutableNodes(int projectId, String jobId) throws ExecutorManagerException {
        return this.numExecutionsDao.fetchNumExecutableNodes(projectId, jobId);
    }

    @Override
    public List<ExecutableFlow> fetchFlowHistory(int projectId, String flowId, int skip, int num) throws ExecutorManagerException {
        return this.executionFlowDao.fetchFlowHistory(projectId, flowId, skip, num);
    }

    @Override
    public List<ExecutableFlow> fetchFlowHistory(int projectId, String flowId, int skip, int num, Status status) throws ExecutorManagerException {
        return this.executionFlowDao.fetchFlowHistory(projectId, flowId, skip, num, status);
    }

    @Override
    public List<ExecutableFlow> fetchFlowHistory(int skip, int num) throws ExecutorManagerException {
        return this.executionFlowDao.fetchFlowHistory(skip, num);
    }

    @Override
    public List<ExecutableFlow> fetchFlowHistory(String projContain, String flowContains, String userNameContains, int status, long startTime, long endTime, int skip, int num) throws ExecutorManagerException {
        return this.executionFlowDao.fetchFlowHistory(projContain, flowContains, userNameContains, status, startTime, endTime, skip, num);
    }

    @Override
    public void addActiveExecutableReference(ExecutionReference reference) throws ExecutorManagerException {
        this.activeExecutingFlowsDao.addActiveExecutableReference(reference);
    }

    @Override
    public void removeActiveExecutableReference(int execid) throws ExecutorManagerException {
        this.activeExecutingFlowsDao.removeActiveExecutableReference(execid);
    }

    @Override
    public boolean updateExecutableReference(int execId, long updateTime) throws ExecutorManagerException {
        return this.activeExecutingFlowsDao.updateExecutableReference(execId, updateTime);
    }

    @Override
    public void uploadExecutableNode(ExecutableNode node, Props inputProps) throws ExecutorManagerException {
        this.executionJobDao.uploadExecutableNode(node, inputProps);
    }

    @Override
    public void updateExecutableNode(ExecutableNode node) throws ExecutorManagerException {
        this.executionJobDao.updateExecutableNode(node);
    }

    @Override
    public List<ExecutableJobInfo> fetchJobInfoAttempts(int execId, String jobId) throws ExecutorManagerException {
        return this.executionJobDao.fetchJobInfoAttempts(execId, jobId);
    }

    @Override
    public ExecutableJobInfo fetchJobInfo(int execId, String jobId, int attempts) throws ExecutorManagerException {
        return this.executionJobDao.fetchJobInfo(execId, jobId, attempts);
    }

    @Override
    public Props fetchExecutionJobInputProps(int execId, String jobId) throws ExecutorManagerException {
        return this.executionJobDao.fetchExecutionJobInputProps(execId, jobId);
    }

    @Override
    public Props fetchExecutionJobOutputProps(int execId, String jobId) throws ExecutorManagerException {
        return this.executionJobDao.fetchExecutionJobOutputProps(execId, jobId);
    }

    @Override
    public Pair<Props, Props> fetchExecutionJobProps(int execId, String jobId) throws ExecutorManagerException {
        return this.executionJobDao.fetchExecutionJobProps(execId, jobId);
    }

    @Override
    public List<ExecutableJobInfo> fetchJobHistory(int projectId, String jobId, int skip, int size) throws ExecutorManagerException {
        return this.executionJobDao.fetchJobHistory(projectId, jobId, skip, size);
    }

    @Override
    public FileIOUtils.LogData fetchLogs(int execId, String name, int attempt, int startByte, int length) throws ExecutorManagerException {
        return this.executionLogsDao.fetchLogs(execId, name, attempt, startByte, length);
    }

    @Override
    public List<Object> fetchAttachments(int execId, String jobId, int attempt) throws ExecutorManagerException {
        return this.executionJobDao.fetchAttachments(execId, jobId, attempt);
    }

    @Override
    public void uploadLogFile(int execId, String name, int attempt, File ... files) throws ExecutorManagerException {
        this.executionLogsDao.uploadLogFile(execId, name, attempt, files);
    }

    @Override
    public void uploadAttachmentFile(ExecutableNode node, File file) throws ExecutorManagerException {
        this.executionJobDao.uploadAttachmentFile(node, file);
    }

    @Override
    public List<Executor> fetchAllExecutors() throws ExecutorManagerException {
        return this.executorDao.fetchAllExecutors();
    }

    @Override
    public List<Executor> fetchActiveExecutors() throws ExecutorManagerException {
        return this.executorDao.fetchActiveExecutors();
    }

    @Override
    public Executor fetchExecutor(String host, int port) throws ExecutorManagerException {
        return this.executorDao.fetchExecutor(host, port);
    }

    @Override
    public Executor fetchExecutor(int executorId) throws ExecutorManagerException {
        return this.executorDao.fetchExecutor(executorId);
    }

    @Override
    public void updateExecutor(Executor executor) throws ExecutorManagerException {
        this.executorDao.updateExecutor(executor);
    }

    @Override
    public Executor addExecutor(String host, int port) throws ExecutorManagerException {
        return this.executorDao.addExecutor(host, port);
    }

    @Override
    public void removeExecutor(String host, int port) throws ExecutorManagerException {
        this.executorDao.removeExecutor(host, port);
    }

    @Override
    public void postExecutorEvent(Executor executor, ExecutorLogEvent.EventType type, String user, String message) throws ExecutorManagerException {
        this.executorEventsDao.postExecutorEvent(executor, type, user, message);
    }

    @Override
    public List<ExecutorLogEvent> getExecutorEvents(Executor executor, int num, int offset) throws ExecutorManagerException {
        return this.executorEventsDao.getExecutorEvents(executor, num, offset);
    }

    @Override
    public void assignExecutor(int executorId, int executionId) throws ExecutorManagerException {
        this.assignExecutorDao.assignExecutor(executorId, executionId);
    }

    @Override
    public Executor fetchExecutorByExecutionId(int executionId) throws ExecutorManagerException {
        return this.executorDao.fetchExecutorByExecutionId(executionId);
    }

    @Override
    public int removeExecutionLogsByTime(long millis) throws ExecutorManagerException {
        return this.executionLogsDao.removeExecutionLogsByTime(millis);
    }

    @Override
    public void unassignExecutor(int executionId) throws ExecutorManagerException {
        this.assignExecutorDao.unassignExecutor(executionId);
    }
}

