/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor.mail;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.mail.MailCreator;
import azkaban.utils.EmailMessage;
import azkaban.utils.Emailer;
import azkaban.utils.Utils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class DefaultMailCreator
implements MailCreator {
    public static final String DEFAULT_MAIL_CREATOR = "default";
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");
    private static final HashMap<String, MailCreator> registeredCreators = new HashMap();
    private static final MailCreator defaultCreator = new DefaultMailCreator();

    public static void registerCreator(String name, MailCreator creator) {
        registeredCreators.put(name, creator);
    }

    public static MailCreator getCreator(String name) {
        MailCreator creator = registeredCreators.get(name);
        if (creator == null) {
            creator = defaultCreator;
        }
        return creator;
    }

    private static String convertMSToString(long timeInMS) {
        if (timeInMS < 0L) {
            return "N/A";
        }
        return DATE_FORMATTER.format(new Date(timeInMS));
    }

    @Override
    public boolean createFirstErrorMessage(ExecutableFlow flow, EmailMessage message, String azkabanName, String scheme, String clientHostname, String clientPortNumber, String ... vars) {
        ExecutionOptions option = flow.getExecutionOptions();
        List<String> emailList = option.getFailureEmails();
        int execId = flow.getExecutionId();
        if (emailList != null && !emailList.isEmpty()) {
            message.addAllToAddress(emailList);
            message.setMimeType("text/html");
            message.setSubject("Flow '" + flow.getFlowId() + "' has encountered a failure on " + azkabanName);
            message.println("<h2 style=\"color:#FF0000\"> Execution '" + flow.getExecutionId() + "' of flow '" + flow.getFlowId() + "' of project '" + flow.getProjectName() + "' has encountered a failure on " + azkabanName + "</h2>");
            if (option.getFailureAction() == ExecutionOptions.FailureAction.CANCEL_ALL) {
                message.println("This flow is set to cancel all currently running jobs.");
            } else if (option.getFailureAction() == ExecutionOptions.FailureAction.FINISH_ALL_POSSIBLE) {
                message.println("This flow is set to complete all jobs that aren't blocked by the failure.");
            } else {
                message.println("This flow is set to complete all currently running jobs before stopping.");
            }
            message.println("<table>");
            message.println("<tr><td>Start Time</td><td>" + DefaultMailCreator.convertMSToString(flow.getStartTime()) + "</td></tr>");
            message.println("<tr><td>End Time</td><td>" + DefaultMailCreator.convertMSToString(flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>Duration</td><td>" + Utils.formatDuration((long)flow.getStartTime(), (long)flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>Status</td><td>" + (Object)((Object)flow.getStatus()) + "</td></tr>");
            message.println("</table>");
            message.println("");
            String executionUrl = scheme + "://" + clientHostname + ":" + clientPortNumber + "/executor?execid=" + execId;
            message.println("<a href=\"" + executionUrl + "\">" + flow.getFlowId() + " Execution Link</a>");
            message.println("");
            message.println("<h3>Reason</h3>");
            List<String> failedJobs = Emailer.findFailedJobs(flow);
            message.println("<ul>");
            for (String jobId : failedJobs) {
                message.println("<li><a href=\"" + executionUrl + "&job=" + jobId + "\">Failed job '" + jobId + "' Link</a></li>");
            }
            message.println("</ul>");
            return true;
        }
        return false;
    }

    @Override
    public boolean createErrorEmail(ExecutableFlow flow, EmailMessage message, String azkabanName, String scheme, String clientHostname, String clientPortNumber, String ... vars) {
        ExecutionOptions option = flow.getExecutionOptions();
        List<String> emailList = option.getFailureEmails();
        int execId = flow.getExecutionId();
        if (emailList != null && !emailList.isEmpty()) {
            message.addAllToAddress(emailList);
            message.setMimeType("text/html");
            message.setSubject("Flow '" + flow.getFlowId() + "' has failed on " + azkabanName);
            message.println("<h2 style=\"color:#FF0000\"> Execution '" + execId + "' of flow '" + flow.getFlowId() + "' of project '" + flow.getProjectName() + "' has failed on " + azkabanName + "</h2>");
            message.println("<table>");
            message.println("<tr><td>Start Time</td><td>" + DefaultMailCreator.convertMSToString(flow.getStartTime()) + "</td></tr>");
            message.println("<tr><td>End Time</td><td>" + DefaultMailCreator.convertMSToString(flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>Duration</td><td>" + Utils.formatDuration((long)flow.getStartTime(), (long)flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>Status</td><td>" + (Object)((Object)flow.getStatus()) + "</td></tr>");
            message.println("</table>");
            message.println("");
            String executionUrl = scheme + "://" + clientHostname + ":" + clientPortNumber + "/executor?execid=" + execId;
            message.println("<a href=\"" + executionUrl + "\">" + flow.getFlowId() + " Execution Link</a>");
            message.println("");
            message.println("<h3>Reason</h3>");
            List<String> failedJobs = Emailer.findFailedJobs(flow);
            message.println("<ul>");
            for (String jobId : failedJobs) {
                message.println("<li><a href=\"" + executionUrl + "&job=" + jobId + "\">Failed job '" + jobId + "' Link</a></li>");
            }
            for (String reasons : vars) {
                message.println("<li>" + reasons + "</li>");
            }
            message.println("</ul>");
            return true;
        }
        return false;
    }

    @Override
    public boolean createSuccessEmail(ExecutableFlow flow, EmailMessage message, String azkabanName, String scheme, String clientHostname, String clientPortNumber, String ... vars) {
        ExecutionOptions option = flow.getExecutionOptions();
        List<String> emailList = option.getSuccessEmails();
        int execId = flow.getExecutionId();
        if (emailList != null && !emailList.isEmpty()) {
            message.addAllToAddress(emailList);
            message.setMimeType("text/html");
            message.setSubject("Flow '" + flow.getFlowId() + "' has succeeded on " + azkabanName);
            message.println("<h2> Execution '" + flow.getExecutionId() + "' of flow '" + flow.getFlowId() + "' of project '" + flow.getProjectName() + "' has succeeded on " + azkabanName + "</h2>");
            message.println("<table>");
            message.println("<tr><td>Start Time</td><td>" + DefaultMailCreator.convertMSToString(flow.getStartTime()) + "</td></tr>");
            message.println("<tr><td>End Time</td><td>" + DefaultMailCreator.convertMSToString(flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>Duration</td><td>" + Utils.formatDuration((long)flow.getStartTime(), (long)flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>Status</td><td>" + (Object)((Object)flow.getStatus()) + "</td></tr>");
            message.println("</table>");
            message.println("");
            String executionUrl = scheme + "://" + clientHostname + ":" + clientPortNumber + "/executor?execid=" + execId;
            message.println("<a href=\"" + executionUrl + "\">" + flow.getFlowId() + " Execution Link</a>");
            return true;
        }
        return false;
    }

    static {
        DefaultMailCreator.registerCreator(DEFAULT_MAIL_CREATOR, defaultCreator);
    }
}

