/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobExecutor.utils.process;

import azkaban.jobExecutor.utils.process.ProcessFailureException;
import azkaban.utils.LogGobbler;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class AzkabanProcess {
    public static String KILL_COMMAND = "kill";
    private final String workingDir;
    private final List<String> cmd;
    private final Map<String, String> env;
    private final Logger logger;
    private final CountDownLatch startupLatch;
    private final CountDownLatch completeLatch;
    private volatile int processId;
    private volatile Process process;
    private boolean isExecuteAsUser = false;
    private String executeAsUserBinary = null;
    private String effectiveUser = null;

    public AzkabanProcess(List<String> cmd, Map<String, String> env, String workingDir, Logger logger) {
        this.cmd = cmd;
        this.env = env;
        this.workingDir = workingDir;
        this.processId = -1;
        this.startupLatch = new CountDownLatch(1);
        this.completeLatch = new CountDownLatch(1);
        this.logger = logger;
    }

    public AzkabanProcess(List<String> cmd, Map<String, String> env, String workingDir, Logger logger, String executeAsUserBinary, String effectiveUser) {
        this(cmd, env, workingDir, logger);
        this.isExecuteAsUser = true;
        this.executeAsUserBinary = executeAsUserBinary;
        this.effectiveUser = effectiveUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        if (this.isStarted() || this.isComplete()) {
            throw new IllegalStateException("The process can only be used once.");
        }
        ProcessBuilder builder = new ProcessBuilder(this.cmd);
        builder.directory(new File(this.workingDir));
        builder.environment().putAll(this.env);
        builder.redirectErrorStream(true);
        this.process = builder.start();
        try {
            this.processId = this.processId(this.process);
            if (this.processId == 0) {
                this.logger.debug((Object)"Spawned thread with unknown process id");
            } else {
                this.logger.debug((Object)("Spawned thread with process id " + this.processId));
            }
            this.startupLatch.countDown();
            LogGobbler outputGobbler = new LogGobbler(new InputStreamReader(this.process.getInputStream(), StandardCharsets.UTF_8), this.logger, Level.INFO, 30);
            LogGobbler errorGobbler = new LogGobbler(new InputStreamReader(this.process.getErrorStream(), StandardCharsets.UTF_8), this.logger, Level.ERROR, 30);
            outputGobbler.start();
            errorGobbler.start();
            int exitCode = -1;
            try {
                exitCode = this.process.waitFor();
            }
            catch (InterruptedException e) {
                this.logger.info((Object)("Process interrupted. Exit code is " + exitCode), (Throwable)e);
            }
            this.completeLatch.countDown();
            outputGobbler.awaitCompletion(5000L);
            errorGobbler.awaitCompletion(5000L);
            if (exitCode != 0) {
                String output = "Stdout:\n" + outputGobbler.getRecentLog() + "\n\n" + "Stderr:\n" + errorGobbler.getRecentLog() + "\n";
                throw new ProcessFailureException(exitCode, output);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.process.getInputStream());
            IOUtils.closeQuietly((OutputStream)this.process.getOutputStream());
            IOUtils.closeQuietly((InputStream)this.process.getErrorStream());
        }
    }

    public void awaitCompletion() throws InterruptedException {
        this.completeLatch.await();
    }

    public void awaitStartup() throws InterruptedException {
        this.startupLatch.await();
    }

    public int getProcessId() {
        this.checkStarted();
        return this.processId;
    }

    public boolean softKill(long time, TimeUnit unit) throws InterruptedException {
        this.checkStarted();
        if (this.processId != 0 && this.isStarted()) {
            try {
                if (this.isExecuteAsUser) {
                    String cmd = String.format("%s %s %s %d", this.executeAsUserBinary, this.effectiveUser, KILL_COMMAND, this.processId);
                    Runtime.getRuntime().exec(cmd);
                } else {
                    String cmd = String.format("%s %d", KILL_COMMAND, this.processId);
                    Runtime.getRuntime().exec(cmd);
                }
                return this.completeLatch.await(time, unit);
            }
            catch (IOException e) {
                this.logger.error((Object)"Kill attempt failed.", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public void hardKill() {
        this.checkStarted();
        if (this.isRunning()) {
            if (this.processId != 0) {
                try {
                    if (this.isExecuteAsUser) {
                        String cmd = String.format("%s %s %s -9 %d", this.executeAsUserBinary, this.effectiveUser, KILL_COMMAND, this.processId);
                        Runtime.getRuntime().exec(cmd);
                    } else {
                        String cmd = String.format("%s -9 %d", KILL_COMMAND, this.processId);
                        Runtime.getRuntime().exec(cmd);
                    }
                }
                catch (IOException e) {
                    this.logger.error((Object)"Kill attempt failed.", (Throwable)e);
                }
            }
            this.process.destroy();
        }
    }

    private int processId(Process process) {
        int processId = 0;
        try {
            Field f = process.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            processId = f.getInt(process);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return processId;
    }

    public boolean isStarted() {
        return this.startupLatch.getCount() == 0L;
    }

    public boolean isComplete() {
        return this.completeLatch.getCount() == 0L;
    }

    public boolean isRunning() {
        return this.isStarted() && !this.isComplete();
    }

    public void checkStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Process has not yet started.");
        }
    }

    public String toString() {
        return "Process(cmd = " + Joiner.on((String)" ").join(this.cmd) + ", env = " + this.env + ", cwd = " + this.workingDir + ")";
    }

    public boolean isExecuteAsUser() {
        return this.isExecuteAsUser;
    }

    public String getEffectiveUser() {
        return this.effectiveUser;
    }
}

