/*
 * Decompiled with CFR 0.152.
 */
package azkaban.metric.inmemoryemitter;

import azkaban.metric.IMetric;
import azkaban.metric.IMetricEmitter;
import azkaban.metric.MetricException;
import azkaban.metric.inmemoryemitter.InMemoryHistoryNode;
import azkaban.utils.Props;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.log4j.Logger;

public class InMemoryMetricEmitter
implements IMetricEmitter {
    protected static final Logger logger = Logger.getLogger(InMemoryMetricEmitter.class);
    private static final String INMEMORY_METRIC_REPORTER_WINDOW = "azkaban.metric.inmemory.interval";
    private static final String INMEMORY_METRIC_NUM_INSTANCES = "azkaban.metric.inmemory.maxinstances";
    private static final String INMEMORY_METRIC_STANDARDDEVIATION_FACTOR = "azkaban.metric.inmemory.standardDeviationFactor";
    private final double standardDeviationFactor;
    protected Map<String, LinkedList<InMemoryHistoryNode>> historyListMapping = new HashMap<String, LinkedList<InMemoryHistoryNode>>();
    private long timeWindow;
    private long numInstances;

    public InMemoryMetricEmitter(Props azkProps) {
        this.timeWindow = azkProps.getLong(INMEMORY_METRIC_REPORTER_WINDOW, 604800000L);
        this.numInstances = azkProps.getLong(INMEMORY_METRIC_NUM_INSTANCES, 50L);
        this.standardDeviationFactor = azkProps.getDouble(INMEMORY_METRIC_STANDARDDEVIATION_FACTOR, 2.0);
    }

    public synchronized void setReportingInterval(long val) {
        this.timeWindow = val;
    }

    public void setReportingInstances(long num) {
        this.numInstances = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportMetric(IMetric<?> metric) throws MetricException {
        String metricName = metric.getName();
        if (!this.historyListMapping.containsKey(metricName)) {
            logger.info((Object)("First time capturing metric: " + metricName));
            this.historyListMapping.put(metricName, new LinkedList());
        }
        LinkedList<InMemoryHistoryNode> linkedList = this.historyListMapping.get(metricName);
        synchronized (linkedList) {
            logger.debug((Object)("Ingesting metric: " + metricName));
            this.historyListMapping.get(metricName).add(new InMemoryHistoryNode(metric.getValue()));
            this.cleanUsingTime(metricName, this.historyListMapping.get(metricName).peekLast().getTimestamp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InMemoryHistoryNode> getMetrics(String metricName, Date from, Date to, Boolean useStats) throws ClassCastException {
        LinkedList<InMemoryHistoryNode> selectedLists = new LinkedList<InMemoryHistoryNode>();
        if (this.historyListMapping.containsKey(metricName)) {
            logger.debug((Object)"selecting snapshots within time frame");
            LinkedList<InMemoryHistoryNode> linkedList = this.historyListMapping.get(metricName);
            synchronized (linkedList) {
                for (InMemoryHistoryNode node : this.historyListMapping.get(metricName)) {
                    if (node.getTimestamp().after(from) && node.getTimestamp().before(to)) {
                        selectedLists.add(node);
                    }
                    if (!node.getTimestamp().after(to)) continue;
                    break;
                }
            }
            if (useStats.booleanValue()) {
                this.statBasedSelectMetricHistory(selectedLists);
            } else {
                this.generalSelectMetricHistory(selectedLists);
            }
        }
        this.cleanUsingTime(metricName, new Date());
        return selectedLists;
    }

    private void statBasedSelectMetricHistory(LinkedList<InMemoryHistoryNode> selectedLists) throws ClassCastException {
        logger.debug((Object)"selecting snapshots which are far away from mean value");
        DescriptiveStatistics descStats = this.getDescriptiveStatistics(selectedLists);
        Double mean = descStats.getMean();
        Double std = descStats.getStandardDeviation();
        Iterator ite = selectedLists.iterator();
        while (ite.hasNext()) {
            InMemoryHistoryNode currentNode = (InMemoryHistoryNode)ite.next();
            double value = ((Number)currentNode.getValue()).doubleValue();
            if (!(value < mean + this.standardDeviationFactor * std) || !(value > mean - this.standardDeviationFactor * std)) continue;
            ite.remove();
        }
    }

    private DescriptiveStatistics getDescriptiveStatistics(LinkedList<InMemoryHistoryNode> selectedLists) throws ClassCastException {
        DescriptiveStatistics descStats = new DescriptiveStatistics();
        for (InMemoryHistoryNode node : selectedLists) {
            descStats.addValue(((Number)node.getValue()).doubleValue());
        }
        return descStats;
    }

    private void generalSelectMetricHistory(LinkedList<InMemoryHistoryNode> selectedLists) {
        logger.debug((Object)"selecting snapshots evenly from across the time interval");
        if ((long)selectedLists.size() > this.numInstances) {
            double step = (double)selectedLists.size() / (double)this.numInstances;
            long nextIndex = 0L;
            long currentIndex = 0L;
            long numSelectedInstances = 1L;
            Iterator ite = selectedLists.iterator();
            while (ite.hasNext()) {
                ite.next();
                if (currentIndex == nextIndex) {
                    nextIndex = (long)Math.floor((double)numSelectedInstances * step + 0.5);
                    ++numSelectedInstances;
                } else {
                    ite.remove();
                }
                ++currentIndex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUsingTime(String metricName, Date firstAllowedDate) {
        if (this.historyListMapping.containsKey(metricName) && this.historyListMapping.get(metricName) != null) {
            LinkedList<InMemoryHistoryNode> linkedList = this.historyListMapping.get(metricName);
            synchronized (linkedList) {
                InMemoryHistoryNode firstNode = this.historyListMapping.get(metricName).peekFirst();
                long localCopyOfTimeWindow = 0L;
                InMemoryMetricEmitter inMemoryMetricEmitter = this;
                synchronized (inMemoryMetricEmitter) {
                    localCopyOfTimeWindow = this.timeWindow;
                }
                while (firstNode != null && TimeUnit.MILLISECONDS.toMillis(firstAllowedDate.getTime() - firstNode.getTimestamp().getTime()) > localCopyOfTimeWindow) {
                    this.historyListMapping.get(metricName).removeFirst();
                    firstNode = this.historyListMapping.get(metricName).peekFirst();
                }
            }
        }
    }

    @Override
    public void purgeAllData() throws MetricException {
        this.historyListMapping.clear();
    }
}

