/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.project.AzkabanNode;
import azkaban.project.FlowTrigger;
import azkaban.utils.Props;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AzkabanFlow
extends AzkabanNode {
    private final Map<String, AzkabanNode> nodes;
    private final FlowTrigger flowTrigger;

    private AzkabanFlow(String name, Props props, Map<String, AzkabanNode> nodes, List<String> dependsOn, FlowTrigger flowTrigger) {
        super(name, "flow", props, dependsOn);
        this.nodes = nodes;
        this.flowTrigger = flowTrigger;
    }

    public Map<String, AzkabanNode> getNodes() {
        return this.nodes;
    }

    public AzkabanNode getNode(String name) {
        return this.nodes.get(name);
    }

    public FlowTrigger getFlowTrigger() {
        return this.flowTrigger;
    }

    public static class AzkabanFlowBuilder {
        private String name;
        private Props props;
        private List<String> dependsOn;
        private Map<String, AzkabanNode> nodes;
        private FlowTrigger flowTrigger;

        public AzkabanFlowBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AzkabanFlowBuilder props(Props props) {
            this.props = props;
            return this;
        }

        public AzkabanFlowBuilder dependsOn(List<String> dependsOn) {
            this.dependsOn = dependsOn == null ? Collections.emptyList() : ImmutableList.copyOf(dependsOn);
            return this;
        }

        public AzkabanFlowBuilder nodes(Collection<? extends AzkabanNode> azkabanNodes) {
            HashMap<String, AzkabanNode> tempNodes = new HashMap<String, AzkabanNode>();
            for (AzkabanNode azkabanNode : azkabanNodes) {
                tempNodes.put(azkabanNode.getName(), azkabanNode);
            }
            this.nodes = ImmutableMap.copyOf(tempNodes);
            return this;
        }

        public AzkabanFlowBuilder flowTrigger(FlowTrigger flowTrigger) {
            this.flowTrigger = flowTrigger;
            return this;
        }

        public AzkabanFlow build() {
            return new AzkabanFlow(this.name, this.props, this.nodes, this.dependsOn, this.flowTrigger);
        }
    }
}

