/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.flow.Edge;
import azkaban.flow.Flow;
import azkaban.flow.FlowProps;
import azkaban.flow.Node;
import azkaban.project.FlowLoader;
import azkaban.project.FlowLoaderUtils;
import azkaban.project.Project;
import azkaban.project.validator.ValidationReport;
import azkaban.utils.Props;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryFlowLoader
implements FlowLoader {
    private static final DirFilter DIR_FILTER = new DirFilter();
    private static final String PROPERTY_SUFFIX = ".properties";
    private static final String JOB_SUFFIX = ".job";
    private static final Logger logger = LoggerFactory.getLogger(DirectoryFlowLoader.class);
    private final Props props;
    private final Set<String> errors = new HashSet<String>();
    private final Map<String, Flow> flowMap = new HashMap<String, Flow>();
    private HashSet<String> rootNodes;
    private HashMap<String, Node> nodeMap;
    private HashMap<String, Map<String, Edge>> nodeDependencies;
    private HashMap<String, Props> jobPropsMap;
    private HashMap<String, Set<String>> flowDependencies;
    private ArrayList<FlowProps> flowPropsList;
    private ArrayList<Props> propsList;
    private Set<String> duplicateJobs;

    public DirectoryFlowLoader(Props props) {
        this.props = props;
    }

    @Override
    public Map<String, Flow> getFlowMap() {
        return this.flowMap;
    }

    @Override
    public Set<String> getErrors() {
        return this.errors;
    }

    public HashMap<String, Props> getJobPropsMap() {
        return this.jobPropsMap;
    }

    public ArrayList<Props> getPropsList() {
        return this.propsList;
    }

    @Override
    public ValidationReport loadProjectFlow(Project project, File projectDir) {
        this.propsList = new ArrayList();
        this.flowPropsList = new ArrayList();
        this.jobPropsMap = new HashMap();
        this.nodeMap = new HashMap();
        this.duplicateJobs = new HashSet<String>();
        this.nodeDependencies = new HashMap();
        this.rootNodes = new HashSet();
        this.flowDependencies = new HashMap();
        this.loadProjectFromDir(projectDir.getPath(), projectDir, null);
        this.resolveDependencies();
        this.buildFlowsFromDependencies();
        this.resolveEmbeddedFlows();
        FlowLoaderUtils.checkJobProperties(project.getId(), this.props, this.jobPropsMap, this.errors);
        return FlowLoaderUtils.generateFlowLoaderReport(this.errors);
    }

    private void loadProjectFromDir(String base, File dir, Props parent) {
        File[] subDirs;
        File[] jobFiles;
        Object[] propertyFiles = dir.listFiles(new FlowLoaderUtils.SuffixFilter(PROPERTY_SUFFIX));
        Arrays.sort(propertyFiles);
        for (Object file : propertyFiles) {
            String relative = this.getRelativeFilePath(base, ((File)file).getPath());
            try {
                parent = new Props(parent, (File)file);
                parent.setSource(relative);
                FlowProps flowProps = new FlowProps(parent);
                this.flowPropsList.add(flowProps);
            }
            catch (IOException e) {
                this.errors.add("Error loading properties " + ((File)file).getName() + ":" + e.getMessage());
            }
            logger.info("Adding " + relative);
            this.propsList.add(parent);
        }
        for (File file : jobFiles = dir.listFiles(new FlowLoaderUtils.SuffixFilter(JOB_SUFFIX))) {
            String jobName = this.getNameWithoutExtension(file);
            try {
                if (this.duplicateJobs.contains(jobName)) continue;
                if (this.jobPropsMap.containsKey(jobName)) {
                    this.errors.add("Duplicate job names found '" + jobName + "'.");
                    this.duplicateJobs.add(jobName);
                    this.jobPropsMap.remove(jobName);
                    this.nodeMap.remove(jobName);
                    continue;
                }
                Props prop = new Props(parent, file);
                String relative = this.getRelativeFilePath(base, file.getPath());
                prop.setSource(relative);
                Node node = new Node(jobName);
                String type = prop.getString("type", null);
                if (type == null) {
                    this.errors.add("Job doesn't have type set '" + jobName + "'.");
                }
                node.setType(type);
                node.setJobSource(relative);
                if (parent != null) {
                    node.setPropsSource(parent.getSource());
                }
                if (prop.getBoolean("root.node", false)) {
                    this.rootNodes.add(jobName);
                }
                this.jobPropsMap.put(jobName, prop);
                this.nodeMap.put(jobName, node);
            }
            catch (IOException e) {
                this.errors.add("Error loading job file " + file.getName() + ":" + e.getMessage());
            }
        }
        for (File file : subDirs = dir.listFiles(DIR_FILTER)) {
            this.loadProjectFromDir(base, file, parent);
        }
    }

    private void resolveEmbeddedFlows() {
        for (String flowId : this.flowDependencies.keySet()) {
            HashSet<String> visited = new HashSet<String>();
            this.resolveEmbeddedFlow(flowId, visited);
        }
    }

    private void resolveEmbeddedFlow(String flowId, Set<String> visited) {
        Set<String> embeddedFlow = this.flowDependencies.get(flowId);
        if (embeddedFlow == null) {
            return;
        }
        visited.add(flowId);
        for (String embeddedFlowId : embeddedFlow) {
            if (visited.contains(embeddedFlowId)) {
                this.errors.add("Embedded flow cycle found in " + flowId + "->" + embeddedFlowId);
                return;
            }
            if (!this.flowMap.containsKey(embeddedFlowId)) {
                this.errors.add("Flow " + flowId + " depends on " + embeddedFlowId + " but can't be found.");
                return;
            }
            this.resolveEmbeddedFlow(embeddedFlowId, visited);
        }
        visited.remove(flowId);
    }

    private void resolveDependencies() {
        for (Node node : this.nodeMap.values()) {
            Map<String, Edge> dependencies;
            Props props = this.jobPropsMap.get(node.getId());
            if (props == null) {
                logger.error("Job props not found!! For some reason.");
                continue;
            }
            List dependencyList = props.getStringList("dependencies", (List)null);
            if (dependencyList == null || (dependencies = this.nodeDependencies.get(node.getId())) != null) continue;
            dependencies = new HashMap<String, Edge>();
            for (String dependencyName : dependencyList) {
                dependencyName = dependencyName == null ? null : dependencyName.trim();
                if (dependencyName == null || dependencyName.isEmpty()) continue;
                Edge edge = new Edge(dependencyName, node.getId());
                Node dependencyNode = this.nodeMap.get(dependencyName);
                if (dependencyNode == null) {
                    if (this.duplicateJobs.contains(dependencyName)) {
                        edge.setError("Ambiguous Dependency. Duplicates found.");
                        dependencies.put(dependencyName, edge);
                        this.errors.add(node.getId() + " has ambiguous dependency " + dependencyName);
                        continue;
                    }
                    edge.setError("Dependency not found.");
                    dependencies.put(dependencyName, edge);
                    this.errors.add(node.getId() + " cannot find dependency " + dependencyName);
                    continue;
                }
                if (dependencyNode == node) {
                    edge.setError("Self cycle found.");
                    dependencies.put(dependencyName, edge);
                    this.errors.add(node.getId() + " has a self cycle");
                    continue;
                }
                dependencies.put(dependencyName, edge);
            }
            if (dependencies.isEmpty()) continue;
            this.nodeDependencies.put(node.getId(), dependencies);
        }
    }

    private void buildFlowsFromDependencies() {
        HashSet<String> nonRootNodes = new HashSet<String>();
        for (Map<String, Edge> edges : this.nodeDependencies.values()) {
            for (String sourceId : edges.keySet()) {
                nonRootNodes.add(sourceId);
            }
        }
        for (Node base : this.nodeMap.values()) {
            if (!this.rootNodes.contains(base.getId()) && nonRootNodes.contains(base.getId())) continue;
            this.rootNodes.add(base.getId());
            Flow flow = new Flow(base.getId());
            Props jobProp = this.jobPropsMap.get(base.getId());
            FlowLoaderUtils.addEmailPropsToFlow(flow, jobProp);
            flow.addAllFlowProperties(this.flowPropsList);
            HashSet<String> visitedNodesOnPath = new HashSet<String>();
            HashSet<String> visitedNodesEver = new HashSet<String>();
            this.constructFlow(flow, base, visitedNodesOnPath, visitedNodesEver);
            flow.initialize();
            this.flowMap.put(base.getId(), flow);
        }
    }

    private void constructFlow(Flow flow, Node node, Set<String> visitedOnPath, Set<String> visitedEver) {
        Map<String, Edge> dependencies;
        visitedOnPath.add(node.getId());
        visitedEver.add(node.getId());
        flow.addNode(node);
        if ("flow".equals(node.getType())) {
            Props props = this.jobPropsMap.get(node.getId());
            String embeddedFlow = props.get((Object)"flow.name");
            Set<String> embeddedFlows = this.flowDependencies.get(flow.getId());
            if (embeddedFlows == null) {
                embeddedFlows = new HashSet<String>();
                this.flowDependencies.put(flow.getId(), embeddedFlows);
            }
            node.setEmbeddedFlowId(embeddedFlow);
            embeddedFlows.add(embeddedFlow);
        }
        if ((dependencies = this.nodeDependencies.get(node.getId())) != null) {
            for (Edge edge : dependencies.values()) {
                if (edge.hasError()) {
                    flow.addEdge(edge);
                    continue;
                }
                if (visitedOnPath.contains(edge.getSourceId())) {
                    edge = new Edge(edge.getSourceId(), node.getId());
                    edge.setError("Cyclical dependencies found.");
                    this.errors.add("Cyclical dependency found at " + edge.getId());
                    flow.addEdge(edge);
                    continue;
                }
                if (visitedEver.contains(edge.getSourceId())) {
                    flow.addEdge(edge);
                    continue;
                }
                flow.addEdge(edge);
                Node sourceNode = this.nodeMap.get(edge.getSourceId());
                this.constructFlow(flow, sourceNode, visitedOnPath, visitedEver);
            }
        }
        visitedOnPath.remove(node.getId());
    }

    private String getNameWithoutExtension(File file) {
        String filename = file.getName();
        int index = filename.lastIndexOf(46);
        return index < 0 ? filename : filename.substring(0, index);
    }

    private String getRelativeFilePath(String basePath, String filePath) {
        return filePath.substring(basePath.length() + 1);
    }

    private static class DirFilter
    implements FileFilter {
        private DirFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

