/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.flow.Edge;
import azkaban.flow.Flow;
import azkaban.flow.FlowProps;
import azkaban.flow.Node;
import azkaban.project.AzkabanFlow;
import azkaban.project.AzkabanNode;
import azkaban.project.FlowLoader;
import azkaban.project.FlowLoaderUtils;
import azkaban.project.NodeBean;
import azkaban.project.NodeBeanLoader;
import azkaban.project.Project;
import azkaban.project.validator.ValidationReport;
import azkaban.utils.Props;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryYamlFlowLoader
implements FlowLoader {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryYamlFlowLoader.class);
    private final Props props;
    private final Set<String> errors = new HashSet<String>();
    private final Map<String, Flow> flowMap = new HashMap<String, Flow>();
    private final Map<String, List<Edge>> edgeMap = new HashMap<String, List<Edge>>();
    private final Map<String, Props> jobPropsMap = new HashMap<String, Props>();

    public DirectoryYamlFlowLoader(Props props) {
        this.props = props;
    }

    @Override
    public Map<String, Flow> getFlowMap() {
        return this.flowMap;
    }

    @Override
    public Set<String> getErrors() {
        return this.errors;
    }

    public Map<String, List<Edge>> getEdgeMap() {
        return this.edgeMap;
    }

    @Override
    public ValidationReport loadProjectFlow(Project project, File projectDir) {
        this.convertYamlFiles(projectDir);
        FlowLoaderUtils.checkJobProperties(project.getId(), this.props, this.jobPropsMap, this.errors);
        return FlowLoaderUtils.generateFlowLoaderReport(this.errors);
    }

    private void convertYamlFiles(File projectDir) {
        for (File file : projectDir.listFiles(new FlowLoaderUtils.SuffixFilter(".flow"))) {
            NodeBeanLoader loader = new NodeBeanLoader();
            try {
                NodeBean nodeBean = loader.load(file);
                if (!loader.validate(nodeBean)) {
                    this.errors.add("Failed to validate nodeBean for " + file.getName() + ". Duplicate nodes found or dependency undefined.");
                    continue;
                }
                AzkabanFlow azkabanFlow = (AzkabanFlow)loader.toAzkabanNode(nodeBean);
                Flow flow = this.convertAzkabanFlowToFlow(azkabanFlow, azkabanFlow.getName(), file);
                this.flowMap.put(flow.getId(), flow);
            }
            catch (Exception e) {
                this.errors.add("Error loading flow yaml file " + file.getName() + ":" + e.getMessage());
            }
        }
    }

    private Flow convertAzkabanFlowToFlow(AzkabanFlow azkabanFlow, String flowName, File flowFile) {
        Flow flow = new Flow(flowName);
        flow.setAzkabanFlowVersion(2.0);
        Props props = azkabanFlow.getProps();
        FlowLoaderUtils.addEmailPropsToFlow(flow, props);
        props.setSource(flowFile.getName());
        flow.addAllFlowProperties((Collection<FlowProps>)ImmutableList.of((Object)new FlowProps(props)));
        azkabanFlow.getNodes().values().stream().map(n -> this.convertAzkabanNodeToNode((AzkabanNode)n, flowName, flowFile)).forEach(n -> flow.addNode((Node)n));
        this.buildFlowEdges(azkabanFlow, flowName);
        if (this.edgeMap.containsKey(flowName)) {
            flow.addAllEdges((Collection<Edge>)this.edgeMap.get(flowName));
        }
        flow.initialize();
        return flow;
    }

    private Node convertAzkabanNodeToNode(AzkabanNode azkabanNode, String flowName, File flowFile) {
        Node node = new Node(azkabanNode.getName());
        node.setType(azkabanNode.getType());
        node.setPropsSource(flowFile.getName());
        node.setJobSource(flowFile.getName());
        if (azkabanNode.getType().equals("flow")) {
            String embeddedFlowId = flowName + ":" + node.getId();
            node.setEmbeddedFlowId(embeddedFlowId);
            Flow flowNode = this.convertAzkabanFlowToFlow((AzkabanFlow)azkabanNode, embeddedFlowId, flowFile);
            flowNode.setEmbeddedFlow(true);
            this.flowMap.put(flowNode.getId(), flowNode);
        }
        this.jobPropsMap.put(flowName + ":" + node.getId(), azkabanNode.getProps());
        return node;
    }

    private void buildFlowEdges(AzkabanFlow azkabanFlow, String flowName) {
        HashSet<String> recStack = new HashSet<String>();
        HashSet<String> visited = new HashSet<String>();
        for (AzkabanNode node : azkabanFlow.getNodes().values()) {
            this.addEdges(node, azkabanFlow, flowName, recStack, visited);
        }
    }

    private void addEdges(AzkabanNode node, AzkabanFlow azkabanFlow, String flowName, HashSet<String> recStack, HashSet<String> visited) {
        if (!visited.contains(node.getName())) {
            recStack.add(node.getName());
            visited.add(node.getName());
            List<String> dependsOnList = node.getDependsOn();
            for (String parent : dependsOnList) {
                Edge edge = new Edge(parent, node.getName());
                if (!this.edgeMap.containsKey(flowName)) {
                    this.edgeMap.put(flowName, new ArrayList());
                }
                this.edgeMap.get(flowName).add(edge);
                if (recStack.contains(parent)) {
                    edge.setError("Cycles found.");
                    this.errors.add("Cycles found at " + edge.getId());
                    continue;
                }
                this.addEdges(azkabanFlow.getNode(parent), azkabanFlow, flowName, recStack, visited);
            }
            recStack.remove(node.getName());
        }
    }
}

