/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.project.DirectoryFlowLoader;
import azkaban.project.DirectoryYamlFlowLoader;
import azkaban.project.FlowLoader;
import azkaban.project.FlowLoaderUtils;
import azkaban.project.ProjectManagerException;
import azkaban.utils.Props;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.commons.lang.ArrayUtils;
import org.yaml.snakeyaml.Yaml;

public class FlowLoaderFactory {
    private final Props props;

    @Inject
    public FlowLoaderFactory(Props props) {
        this.props = Objects.requireNonNull(props, "Props is null");
    }

    public FlowLoader createFlowLoader(File projectDir) throws ProjectManagerException {
        Object[] projectFileList = projectDir.listFiles(new FlowLoaderUtils.SuffixFilter(".project"));
        if (projectFileList == null) {
            throw new ProjectManagerException("Error reading project directory. Input is not a directory or IO error happens.");
        }
        if (ArrayUtils.isNotEmpty((Object[])projectFileList)) {
            Map azkabanProject;
            if (projectFileList.length > 1) {
                throw new ProjectManagerException("Duplicate project YAML files found in the project directory. Only one is allowed.");
            }
            try (FileInputStream fis = new FileInputStream((File)projectFileList[0]);){
                azkabanProject = (Map)new Yaml().load((InputStream)fis);
            }
            catch (IOException e) {
                throw new ProjectManagerException("Error reading project YAML file.", e);
            }
            if (azkabanProject == null || !azkabanProject.containsKey("azkaban-flow-version")) {
                throw new ProjectManagerException("azkaban-flow-version is not specified in the project YAML file.");
            }
            if (azkabanProject.get("azkaban-flow-version").equals(2.0)) {
                return new DirectoryYamlFlowLoader(this.props);
            }
            throw new ProjectManagerException("Invalid azkaban-flow-version in the project YAML file.");
        }
        return new DirectoryFlowLoader(this.props);
    }
}

