/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.project.CronSchedule;
import azkaban.project.FlowTriggerDependency;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FlowTrigger
implements Serializable {
    private final Map<String, FlowTriggerDependency> dependencies;
    private final CronSchedule schedule;
    private final Duration maxWaitDuration;

    public FlowTrigger(CronSchedule schedule, List<FlowTriggerDependency> dependencies, Duration maxWaitDuration) {
        Preconditions.checkNotNull((Object)schedule, (Object)"schedule cannot be null");
        Preconditions.checkNotNull(dependencies, (Object)"dependency cannot be null");
        Preconditions.checkNotNull((Object)maxWaitDuration, (Object)"max wait time cannot be null");
        this.validateDependencies(dependencies);
        this.schedule = schedule;
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        dependencies.forEach(dep -> builder.put((Object)dep.getName(), dep));
        this.dependencies = builder.build();
        this.maxWaitDuration = maxWaitDuration;
    }

    private void validateDepNameUniqueness(List<FlowTriggerDependency> dependencies) {
        HashSet<String> seen = new HashSet<String>();
        for (FlowTriggerDependency dep : dependencies) {
            Preconditions.checkArgument((boolean)seen.add(dep.getName()), (Object)String.format("duplicate dependency.name %s found, dependency.name should be unique", dep.getName()));
        }
    }

    public String toString() {
        return "FlowTrigger{schedule=" + this.schedule + ", maxWaitDurationInMins=" + this.maxWaitDuration.toMinutes() + "\n " + StringUtils.join(this.dependencies.values(), (String)"\n") + '}';
    }

    private void validateDepDefinitionUniqueness(List<FlowTriggerDependency> dependencies) {
        HashSet<String> seen = new HashSet<String>();
        for (FlowTriggerDependency dep : dependencies) {
            Map<String, String> props = dep.getProps();
            Preconditions.checkArgument((boolean)seen.add(dep.getType() + ":" + props.toString()), (Object)String.format("duplicate dependency config %s found, dependency config should be unique", dep.getName()));
        }
    }

    private void validateDependencies(List<FlowTriggerDependency> dependencies) {
        this.validateDepNameUniqueness(dependencies);
        this.validateDepDefinitionUniqueness(dependencies);
    }

    public FlowTriggerDependency getDependencyByName(String name) {
        return this.dependencies.get(name);
    }

    public Collection<FlowTriggerDependency> getDependencies() {
        return this.dependencies.values();
    }

    public Duration getMaxWaitDuration() {
        return this.maxWaitDuration;
    }

    public CronSchedule getSchedule() {
        return this.schedule;
    }
}

