/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.Constants;
import azkaban.project.AzkabanFlow;
import azkaban.project.AzkabanJob;
import azkaban.project.AzkabanNode;
import azkaban.project.CronSchedule;
import azkaban.project.FlowTrigger;
import azkaban.project.FlowTriggerBean;
import azkaban.project.FlowTriggerDependency;
import azkaban.project.NodeBean;
import azkaban.project.ProjectManagerException;
import azkaban.project.TriggerDependencyBean;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.quartz.CronExpression;
import org.yaml.snakeyaml.Yaml;

public class NodeBeanLoader {
    public NodeBean load(File flowFile) throws Exception {
        Preconditions.checkArgument((flowFile != null && flowFile.exists() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)flowFile.getName().endsWith(".flow"));
        NodeBean nodeBean = (NodeBean)new Yaml().loadAs((InputStream)new FileInputStream(flowFile), NodeBean.class);
        if (nodeBean == null) {
            throw new ProjectManagerException("Failed to load flow file " + flowFile.getName() + ". Node bean is null .");
        }
        nodeBean.setName(this.getFlowName(flowFile));
        nodeBean.setType("flow");
        return nodeBean;
    }

    public boolean validate(NodeBean nodeBean) {
        HashSet<String> nodeNames = new HashSet<String>();
        for (NodeBean n : nodeBean.getNodes()) {
            if (nodeNames.add(n.getName())) continue;
            return false;
        }
        for (NodeBean n : nodeBean.getNodes()) {
            if (n.getDependsOn() == null || nodeNames.containsAll(n.getDependsOn())) continue;
            return false;
        }
        return true;
    }

    public AzkabanNode toAzkabanNode(NodeBean nodeBean) {
        if (nodeBean.getType().equals("flow")) {
            return new AzkabanFlow.AzkabanFlowBuilder().name(nodeBean.getName()).props(nodeBean.getProps()).dependsOn(nodeBean.getDependsOn()).nodes(nodeBean.getNodes().stream().map(this::toAzkabanNode).collect(Collectors.toList())).flowTrigger(this.toFlowTrigger(nodeBean.getTrigger())).build();
        }
        return new AzkabanJob.AzkabanJobBuilder().name(nodeBean.getName()).props(nodeBean.getProps()).type(nodeBean.getType()).dependsOn(nodeBean.getDependsOn()).build();
    }

    private void validateSchedule(FlowTriggerBean flowTriggerBean) {
        Map<String, String> scheduleMap = flowTriggerBean.getSchedule();
        Preconditions.checkNotNull(scheduleMap, (Object)"flow trigger schedule must not be null");
        Preconditions.checkArgument((scheduleMap.containsKey("type") && scheduleMap.get("type").equals("cron") ? 1 : 0) != 0, (Object)"flow trigger schedule type must be cron");
        Preconditions.checkArgument((scheduleMap.containsKey("value") && CronExpression.isValidExpression((String)scheduleMap.get("value")) ? 1 : 0) != 0, (Object)"flow trigger schedule value must be a valid cron expression");
        Preconditions.checkArgument((scheduleMap.size() == 2 ? 1 : 0) != 0, (Object)"flow trigger schedule must contain type and value only");
    }

    private void validateFlowTriggerBean(FlowTriggerBean flowTriggerBean) {
        Preconditions.checkArgument((flowTriggerBean.getMaxWaitMins() >= Constants.MIN_FLOW_TRIGGER_WAIT_TIME.toMinutes() ? 1 : 0) != 0, (Object)("max wait min must be at least " + Constants.MIN_FLOW_TRIGGER_WAIT_TIME.toMinutes() + " min(s)"));
        this.validateSchedule(flowTriggerBean);
        this.validateTriggerDependencies(flowTriggerBean.getTriggerDependencies());
    }

    private void validateDepNameUniqueness(List<TriggerDependencyBean> dependencies) {
        HashSet<String> seen = new HashSet<String>();
        for (TriggerDependencyBean dep : dependencies) {
            Preconditions.checkArgument((boolean)seen.add(dep.getName()), (Object)String.format("duplicate dependency.name %s found, dependency.name should be unique", dep.getName()));
        }
    }

    private void validateDepDefinitionUniqueness(List<TriggerDependencyBean> dependencies) {
        for (int i = 0; i < dependencies.size(); ++i) {
            for (int j = i + 1; j < dependencies.size(); ++j) {
                boolean duplicateDepDefFound = dependencies.get(i).getType().equals(dependencies.get(j).getType()) && dependencies.get(i).getParams().equals(dependencies.get(j).getParams());
                Preconditions.checkArgument((!duplicateDepDefFound ? 1 : 0) != 0, (Object)String.format("duplicate dependencyconfig %s found, dependency config should be unique", dependencies.get(i).getName()));
            }
        }
    }

    private void validateNameAndTypeArePresent(List<TriggerDependencyBean> dependencies) {
        for (TriggerDependencyBean dep : dependencies) {
            Preconditions.checkNotNull((Object)dep.getName(), (Object)"dependency name is required");
            Preconditions.checkNotNull((Object)dep.getType(), (Object)("dependency type is required for " + dep.getName()));
        }
    }

    private void validateTriggerDependencies(List<TriggerDependencyBean> dependencies) {
        this.validateNameAndTypeArePresent(dependencies);
        this.validateDepNameUniqueness(dependencies);
        this.validateDepDefinitionUniqueness(dependencies);
        this.validateDepType(dependencies);
    }

    private void validateDepType(List<TriggerDependencyBean> dependencies) {
    }

    public FlowTrigger toFlowTrigger(FlowTriggerBean flowTriggerBean) {
        if (flowTriggerBean == null) {
            return null;
        }
        this.validateFlowTriggerBean(flowTriggerBean);
        if (flowTriggerBean.getMaxWaitMins() > Constants.DEFAULT_FLOW_TRIGGER_MAX_WAIT_TIME.toMinutes()) {
            flowTriggerBean.setMaxWaitMins(Constants.DEFAULT_FLOW_TRIGGER_MAX_WAIT_TIME.toMinutes());
        }
        return new FlowTrigger(new CronSchedule(flowTriggerBean.getSchedule().get("value")), flowTriggerBean.getTriggerDependencies().stream().map(d -> new FlowTriggerDependency(d.getName(), d.getType(), d.getParams())).collect(Collectors.toList()), Duration.ofMinutes(flowTriggerBean.getMaxWaitMins()));
    }

    public String getFlowName(File flowFile) {
        Preconditions.checkArgument((flowFile != null && flowFile.exists() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)flowFile.getName().endsWith(".flow"));
        return Files.getNameWithoutExtension((String)flowFile.getName());
    }
}

