/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.flow.Flow;
import azkaban.user.Permission;
import azkaban.user.User;
import azkaban.utils.Pair;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Project {
    private final int id;
    private final String name;
    private final LinkedHashMap<String, Permission> userPermissionMap = new LinkedHashMap();
    private final LinkedHashMap<String, Permission> groupPermissionMap = new LinkedHashMap();
    private final HashSet<String> proxyUsers = new HashSet();
    private boolean active = true;
    private String description;
    private int version = -1;
    private long createTimestamp;
    private long lastModifiedTimestamp;
    private String lastModifiedUser;
    private String source;
    private Map<String, Flow> flows = new HashMap<String, Flow>();
    private Map<String, Object> metadata = new HashMap<String, Object>();

    public Project(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static Project projectFromObject(Object object) {
        Map projectObject = (Map)object;
        int id = (Integer)projectObject.get("id");
        String name = (String)projectObject.get("name");
        String description = (String)projectObject.get("description");
        String lastModifiedUser = (String)projectObject.get("lastModifiedUser");
        long createTimestamp = Project.coerceToLong(projectObject.get("createTimestamp"));
        long lastModifiedTimestamp = Project.coerceToLong(projectObject.get("lastModifiedTimestamp"));
        String source = (String)projectObject.get("source");
        Boolean active = (Boolean)projectObject.get("active");
        active = active == null ? true : active;
        int version = (Integer)projectObject.get("version");
        Map metadata = (Map)projectObject.get("metadata");
        Project project = new Project(id, name);
        project.setVersion(version);
        project.setDescription(description);
        project.setCreateTimestamp(createTimestamp);
        project.setLastModifiedTimestamp(lastModifiedTimestamp);
        project.setLastModifiedUser(lastModifiedUser);
        project.setActive(active);
        if (source != null) {
            project.setSource(source);
        }
        if (metadata != null) {
            project.setMetadata(metadata);
        }
        List proxyUserList = (List)projectObject.get("proxyUsers");
        project.addAllProxyUsers(proxyUserList);
        return project;
    }

    private static long coerceToLong(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue();
        }
        return (Long)obj;
    }

    public String getName() {
        return this.name;
    }

    public Flow getFlow(String flowId) {
        if (this.flows == null) {
            return null;
        }
        return this.flows.get(flowId);
    }

    public Map<String, Flow> getFlowMap() {
        return this.flows;
    }

    public List<Flow> getFlows() {
        ArrayList<Flow> retFlow = null;
        retFlow = this.flows != null ? new ArrayList<Flow>(this.flows.values()) : new ArrayList<Flow>();
        return retFlow;
    }

    public void setFlows(Map<String, Flow> flows) {
        this.flows = ImmutableMap.copyOf(flows);
    }

    public Permission getCollectivePermission(User user) {
        Permission permissions = new Permission();
        Permission perm = this.userPermissionMap.get(user.getUserId());
        if (perm != null) {
            permissions.addPermissions(perm);
        }
        for (String group : user.getGroups()) {
            perm = this.groupPermissionMap.get(group);
            if (perm == null) continue;
            permissions.addPermissions(perm);
        }
        return permissions;
    }

    public Set<String> getProxyUsers() {
        return new HashSet<String>(this.proxyUsers);
    }

    public void addAllProxyUsers(Collection<String> proxyUsers) {
        this.proxyUsers.addAll(proxyUsers);
    }

    public boolean hasProxyUser(String proxy) {
        return this.proxyUsers.contains(proxy);
    }

    public void addProxyUser(String user) {
        this.proxyUsers.add(user);
    }

    public void removeProxyUser(String user) {
        this.proxyUsers.remove(user);
    }

    public boolean hasPermission(User user, Permission.Type type) {
        Permission perm = this.userPermissionMap.get(user.getUserId());
        if (perm != null && (perm.isPermissionSet(Permission.Type.ADMIN) || perm.isPermissionSet(type))) {
            return true;
        }
        return this.hasGroupPermission(user, type);
    }

    public boolean hasUserPermission(User user, Permission.Type type) {
        Permission perm = this.userPermissionMap.get(user.getUserId());
        if (perm == null) {
            return false;
        }
        return perm.isPermissionSet(Permission.Type.ADMIN) || perm.isPermissionSet(type);
    }

    public boolean hasGroupPermission(User user, Permission.Type type) {
        for (String group : user.getGroups()) {
            Permission perm = this.groupPermissionMap.get(group);
            if (perm == null || !perm.isPermissionSet(Permission.Type.ADMIN) && !perm.isPermissionSet(type)) continue;
            return true;
        }
        return false;
    }

    public List<String> getUsersWithPermission(Permission.Type type) {
        ArrayList<String> users = new ArrayList<String>();
        for (Map.Entry<String, Permission> entry : this.userPermissionMap.entrySet()) {
            Permission perm = entry.getValue();
            if (!perm.isPermissionSet(type)) continue;
            users.add(entry.getKey());
        }
        return users;
    }

    public List<Pair<String, Permission>> getUserPermissions() {
        ArrayList<Pair<String, Permission>> permissions = new ArrayList<Pair<String, Permission>>();
        for (Map.Entry<String, Permission> entry : this.userPermissionMap.entrySet()) {
            permissions.add(new Pair<String, Permission>(entry.getKey(), entry.getValue()));
        }
        return permissions;
    }

    public List<Pair<String, Permission>> getGroupPermissions() {
        ArrayList<Pair<String, Permission>> permissions = new ArrayList<Pair<String, Permission>>();
        for (Map.Entry<String, Permission> entry : this.groupPermissionMap.entrySet()) {
            permissions.add(new Pair<String, Permission>(entry.getKey(), entry.getValue()));
        }
        return permissions;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUserPermission(String userid, Permission perm) {
        this.userPermissionMap.put(userid, perm);
    }

    public void setGroupPermission(String group, Permission perm) {
        this.groupPermissionMap.put(group, perm);
    }

    public Permission getUserPermission(User user) {
        return this.userPermissionMap.get(user.getUserId());
    }

    public Permission getGroupPermission(String group) {
        return this.groupPermissionMap.get(group);
    }

    public Permission getUserPermission(String userID) {
        return this.userPermissionMap.get(userID);
    }

    public void removeGroupPermission(String group) {
        this.groupPermissionMap.remove(group);
    }

    public void removeUserPermission(String userId) {
        this.userPermissionMap.remove(userId);
    }

    public void clearUserPermission() {
        this.userPermissionMap.clear();
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(long createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public long getLastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public void setLastModifiedTimestamp(long lastModifiedTimestamp) {
        this.lastModifiedTimestamp = lastModifiedTimestamp;
    }

    public Object toObject() {
        HashMap<String, Object> projectObject = new HashMap<String, Object>();
        projectObject.put("id", this.id);
        projectObject.put("name", this.name);
        projectObject.put("description", this.description);
        projectObject.put("createTimestamp", this.createTimestamp);
        projectObject.put("lastModifiedTimestamp", this.lastModifiedTimestamp);
        projectObject.put("lastModifiedUser", this.lastModifiedUser);
        projectObject.put("version", this.version);
        if (!this.active) {
            projectObject.put("active", false);
        }
        if (this.source != null) {
            projectObject.put("source", this.source);
        }
        if (this.metadata != null) {
            projectObject.put("metadata", this.metadata);
        }
        ArrayList<String> proxyUserList = new ArrayList<String>(this.proxyUsers);
        projectObject.put("proxyUsers", proxyUserList);
        return projectObject;
    }

    public String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    public void setLastModifiedUser(String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.active ? 1231 : 1237);
        result = 31 * result + (int)(this.createTimestamp ^ this.createTimestamp >>> 32);
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + (int)(this.lastModifiedTimestamp ^ this.lastModifiedTimestamp >>> 32);
        result = 31 * result + (this.lastModifiedUser == null ? 0 : this.lastModifiedUser.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        if (this.active != other.active) {
            return false;
        }
        if (this.createTimestamp != other.createTimestamp) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.lastModifiedTimestamp != other.lastModifiedTimestamp) {
            return false;
        }
        if (this.lastModifiedUser == null ? other.lastModifiedUser != null : !this.lastModifiedUser.equals(other.lastModifiedUser)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return this.version == other.version;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Map<String, Object> getMetadata() {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        return this.metadata;
    }

    protected void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public int getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

