/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.flow.Flow;
import azkaban.project.Project;
import azkaban.project.ProjectFileHandler;
import azkaban.project.ProjectLogEvent;
import azkaban.project.ProjectManagerException;
import azkaban.user.Permission;
import azkaban.user.User;
import azkaban.utils.Props;
import azkaban.utils.Triple;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface ProjectLoader {
    public List<Project> fetchAllActiveProjects() throws ProjectManagerException;

    public Project fetchProjectById(int var1) throws ProjectManagerException;

    public Project fetchProjectByName(String var1) throws ProjectManagerException;

    public Project createNewProject(String var1, String var2, User var3) throws ProjectManagerException;

    public void removeProject(Project var1, String var2) throws ProjectManagerException;

    public void updatePermission(Project var1, String var2, Permission var3, boolean var4) throws ProjectManagerException;

    public void removePermission(Project var1, String var2, boolean var3) throws ProjectManagerException;

    public void updateDescription(Project var1, String var2, String var3) throws ProjectManagerException;

    public boolean postEvent(Project var1, ProjectLogEvent.EventType var2, String var3, String var4);

    public List<ProjectLogEvent> getProjectEvents(Project var1, int var2, int var3) throws ProjectManagerException;

    public void uploadProjectFile(int var1, int var2, File var3, String var4) throws ProjectManagerException;

    public void addProjectVersion(int var1, int var2, File var3, String var4, byte[] var5, String var6) throws ProjectManagerException;

    public ProjectFileHandler fetchProjectMetaData(int var1, int var2);

    public ProjectFileHandler getUploadedFile(int var1, int var2) throws ProjectManagerException;

    public void changeProjectVersion(Project var1, int var2, String var3) throws ProjectManagerException;

    public void updateFlow(Project var1, int var2, Flow var3) throws ProjectManagerException;

    public void uploadFlows(Project var1, int var2, Collection<Flow> var3) throws ProjectManagerException;

    public void uploadFlow(Project var1, int var2, Flow var3) throws ProjectManagerException;

    public Flow fetchFlow(Project var1, String var2) throws ProjectManagerException;

    public List<Flow> fetchAllProjectFlows(Project var1) throws ProjectManagerException;

    public int getLatestProjectVersion(Project var1) throws ProjectManagerException;

    public void uploadProjectProperty(Project var1, Props var2) throws ProjectManagerException;

    public void uploadProjectProperties(Project var1, List<Props> var2) throws ProjectManagerException;

    public Props fetchProjectProperty(Project var1, String var2) throws ProjectManagerException;

    public Map<String, Props> fetchProjectProperties(int var1, int var2) throws ProjectManagerException;

    public void cleanOlderProjectVersion(int var1, int var2) throws ProjectManagerException;

    public void updateProjectProperty(Project var1, Props var2) throws ProjectManagerException;

    public Props fetchProjectProperty(int var1, int var2, String var3) throws ProjectManagerException;

    public List<Triple<String, Boolean, Permission>> getProjectPermissions(Project var1) throws ProjectManagerException;

    public void updateProjectSettings(Project var1) throws ProjectManagerException;

    public void uploadFlowFile(int var1, int var2, File var3, int var4) throws ProjectManagerException;

    public File getUploadedFlowFile(int var1, int var2, String var3, int var4, File var5) throws ProjectManagerException, IOException;

    public int getLatestFlowVersion(int var1, int var2, String var3) throws ProjectManagerException;

    public boolean isFlowFileUploaded(int var1, int var2) throws ProjectManagerException;
}

