/*
 * Decompiled with CFR 0.152.
 */
package azkaban.sla;

import azkaban.executor.ExecutableFlow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SlaOption {
    public static final String TYPE_FLOW_FINISH = "FlowFinish";
    public static final String TYPE_FLOW_SUCCEED = "FlowSucceed";
    public static final String TYPE_JOB_FINISH = "JobFinish";
    public static final String TYPE_JOB_SUCCEED = "JobSucceed";
    public static final String INFO_DURATION = "Duration";
    public static final String INFO_FLOW_NAME = "FlowName";
    public static final String INFO_JOB_NAME = "JobName";
    public static final String INFO_EMAIL_LIST = "EmailList";
    public static final String ALERT_TYPE = "SlaAlertType";
    public static final String ACTION_CANCEL_FLOW = "SlaCancelFlow";
    public static final String ACTION_ALERT = "SlaAlert";
    public static final String ACTION_KILL_JOB = "SlaKillJob";
    private static final DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"MM/dd, YYYY HH:mm");
    private String type;
    private Map<String, Object> info;
    private List<String> actions;

    public SlaOption(String type, List<String> actions, Map<String, Object> info) {
        this.type = type;
        this.info = info;
        this.actions = actions;
    }

    public static List<SlaOption> getJobLevelSLAOptions(ExecutableFlow flow) {
        HashSet<String> jobLevelSLAs = new HashSet<String>(Arrays.asList(TYPE_JOB_FINISH, TYPE_JOB_SUCCEED));
        return flow.getSlaOptions().stream().filter(slaOption -> jobLevelSLAs.contains(slaOption.getType())).collect(Collectors.toList());
    }

    public static List<SlaOption> getFlowLevelSLAOptions(ExecutableFlow flow) {
        HashSet<String> flowLevelSLAs = new HashSet<String>(Arrays.asList(TYPE_FLOW_FINISH, TYPE_FLOW_SUCCEED));
        return flow.getSlaOptions().stream().filter(slaOption -> flowLevelSLAs.contains(slaOption.getType())).collect(Collectors.toList());
    }

    public static SlaOption fromObject(Object object) {
        HashMap slaObj = (HashMap)object;
        String type = (String)slaObj.get("type");
        List actions = (List)slaObj.get("actions");
        Map info = (Map)slaObj.get("info");
        return new SlaOption(type, actions, info);
    }

    public static String createSlaMessage(SlaOption slaOption, ExecutableFlow flow) {
        String type = slaOption.getType();
        int execId = flow.getExecutionId();
        if (type.equals(TYPE_FLOW_FINISH)) {
            String flowName = (String)slaOption.getInfo().get(INFO_FLOW_NAME);
            String duration = (String)slaOption.getInfo().get(INFO_DURATION);
            String basicinfo = "SLA Alert: Your flow " + flowName + " failed to FINISH within " + duration + "<br/>";
            String expected = "Here is details : <br/>Flow " + flowName + " in execution " + execId + " is expected to FINISH within " + duration + " from " + fmt.print((ReadableInstant)new DateTime(flow.getStartTime())) + "<br/>";
            String actual = "Actual flow status is " + (Object)((Object)flow.getStatus());
            return basicinfo + expected + actual;
        }
        if (type.equals(TYPE_FLOW_SUCCEED)) {
            String flowName = (String)slaOption.getInfo().get(INFO_FLOW_NAME);
            String duration = (String)slaOption.getInfo().get(INFO_DURATION);
            String basicinfo = "SLA Alert: Your flow " + flowName + " failed to SUCCEED within " + duration + "<br/>";
            String expected = "Here is details : <br/>Flow " + flowName + " in execution " + execId + " expected to FINISH within " + duration + " from " + fmt.print((ReadableInstant)new DateTime(flow.getStartTime())) + "<br/>";
            String actual = "Actual flow status is " + (Object)((Object)flow.getStatus());
            return basicinfo + expected + actual;
        }
        if (type.equals(TYPE_JOB_FINISH)) {
            String jobName = (String)slaOption.getInfo().get(INFO_JOB_NAME);
            String duration = (String)slaOption.getInfo().get(INFO_DURATION);
            return "SLA Alert: Your job " + jobName + " failed to FINISH within " + duration + " in execution " + execId;
        }
        if (type.equals(TYPE_JOB_SUCCEED)) {
            String jobName = (String)slaOption.getInfo().get(INFO_JOB_NAME);
            String duration = (String)slaOption.getInfo().get(INFO_DURATION);
            return "SLA Alert: Your job " + jobName + " failed to SUCCEED within " + duration + " in execution " + execId;
        }
        return "Unrecognized SLA type " + type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, Object> getInfo() {
        return this.info;
    }

    public void setInfo(Map<String, Object> info) {
        this.info = info;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public Map<String, Object> toObject() {
        HashMap<String, Object> slaObj = new HashMap<String, Object>();
        slaObj.put("type", this.type);
        slaObj.put("info", this.info);
        slaObj.put("actions", this.actions);
        return slaObj;
    }

    public Object toWebObject() {
        HashMap<String, Object> slaObj = new HashMap<String, Object>();
        if (this.type.equals(TYPE_FLOW_FINISH) || this.type.equals(TYPE_FLOW_SUCCEED)) {
            slaObj.put("id", "");
        } else {
            slaObj.put("id", this.info.get(INFO_JOB_NAME));
        }
        slaObj.put("duration", this.info.get(INFO_DURATION));
        if (this.type.equals(TYPE_FLOW_FINISH) || this.type.equals(TYPE_JOB_FINISH)) {
            slaObj.put("rule", "FINISH");
        } else {
            slaObj.put("rule", "SUCCESS");
        }
        ArrayList<String> actionsObj = new ArrayList<String>();
        for (String act : this.actions) {
            if (act.equals(ACTION_ALERT)) {
                actionsObj.add("EMAIL");
                continue;
            }
            actionsObj.add("KILL");
        }
        slaObj.put("actions", actionsObj);
        return slaObj;
    }

    public String toString() {
        return "Sla of " + this.getType() + this.getInfo() + this.getActions();
    }
}

