/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger.builtin;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutorManagerAdapter;
import azkaban.executor.ExecutorManagerException;
import azkaban.flow.Flow;
import azkaban.flow.FlowUtils;
import azkaban.project.Project;
import azkaban.project.ProjectManager;
import azkaban.sla.SlaOption;
import azkaban.trigger.TriggerAction;
import azkaban.trigger.TriggerManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExecuteFlowAction
implements TriggerAction {
    public static final String type = "ExecuteFlowAction";
    public static final String EXEC_ID = "ExecuteFlowAction.execid";
    private static ExecutorManagerAdapter executorManager;
    private static TriggerManager triggerManager;
    private static ProjectManager projectManager;
    private static Logger logger;
    private final String actionId;
    private final String projectName;
    private int projectId;
    private String flowName;
    private String submitUser;
    private ExecutionOptions executionOptions = new ExecutionOptions();
    private List<SlaOption> slaOptions;

    public ExecuteFlowAction(String actionId, int projectId, String projectName, String flowName, String submitUser, ExecutionOptions executionOptions, List<SlaOption> slaOptions) {
        this.actionId = actionId;
        this.projectId = projectId;
        this.projectName = projectName;
        this.flowName = flowName;
        this.submitUser = submitUser;
        this.executionOptions = executionOptions;
        this.slaOptions = slaOptions;
    }

    public static void setLogger(Logger logger) {
        ExecuteFlowAction.logger = logger;
    }

    public static ExecutorManagerAdapter getExecutorManager() {
        return executorManager;
    }

    public static void setExecutorManager(ExecutorManagerAdapter executorManager) {
        ExecuteFlowAction.executorManager = executorManager;
    }

    public static TriggerManager getTriggerManager() {
        return triggerManager;
    }

    public static void setTriggerManager(TriggerManager triggerManager) {
        ExecuteFlowAction.triggerManager = triggerManager;
    }

    public static ProjectManager getProjectManager() {
        return projectManager;
    }

    public static void setProjectManager(ProjectManager projectManager) {
        ExecuteFlowAction.projectManager = projectManager;
    }

    public static TriggerAction createFromJson(HashMap<String, Object> obj) {
        HashMap<String, Object> jsonObj = obj;
        String objType = (String)jsonObj.get("type");
        if (!objType.equals(type)) {
            throw new RuntimeException("Cannot create action of ExecuteFlowAction from " + objType);
        }
        String actionId = (String)jsonObj.get("actionId");
        int projectId = Integer.valueOf((String)jsonObj.get("projectId"));
        String projectName = (String)jsonObj.get("projectName");
        String flowName = (String)jsonObj.get("flowName");
        String submitUser = (String)jsonObj.get("submitUser");
        ExecutionOptions executionOptions = null;
        if (jsonObj.containsKey("executionOptions")) {
            executionOptions = ExecutionOptions.createFromObject(jsonObj.get("executionOptions"));
        }
        ArrayList<SlaOption> slaOptions = null;
        if (jsonObj.containsKey("slaOptions")) {
            slaOptions = new ArrayList<SlaOption>();
            List slaOptionsObj = (List)jsonObj.get("slaOptions");
            for (Object slaObj : slaOptionsObj) {
                slaOptions.add(SlaOption.fromObject(slaObj));
            }
        }
        return new ExecuteFlowAction(actionId, projectId, projectName, flowName, submitUser, executionOptions, slaOptions);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public int getProjectId() {
        return this.projectId;
    }

    protected void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    protected void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public String getSubmitUser() {
        return this.submitUser;
    }

    protected void setSubmitUser(String submitUser) {
        this.submitUser = submitUser;
    }

    public ExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }

    protected void setExecutionOptions(ExecutionOptions executionOptions) {
        this.executionOptions = executionOptions;
    }

    public List<SlaOption> getSlaOptions() {
        return this.slaOptions;
    }

    protected void setSlaOptions(List<SlaOption> slaOptions) {
        this.slaOptions = slaOptions;
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public TriggerAction fromJson(Object obj) {
        return ExecuteFlowAction.createFromJson((HashMap)obj);
    }

    @Override
    public Object toJson() {
        HashMap<String, Object> jsonObj = new HashMap<String, Object>();
        jsonObj.put("actionId", this.actionId);
        jsonObj.put("type", type);
        jsonObj.put("projectId", String.valueOf(this.projectId));
        jsonObj.put("projectName", this.projectName);
        jsonObj.put("flowName", this.flowName);
        jsonObj.put("submitUser", this.submitUser);
        if (this.executionOptions != null) {
            jsonObj.put("executionOptions", this.executionOptions.toObject());
        }
        if (this.slaOptions != null) {
            ArrayList<Map<String, Object>> slaOptionsObj = new ArrayList<Map<String, Object>>();
            for (SlaOption sla : this.slaOptions) {
                slaOptionsObj.add(sla.toObject());
            }
            jsonObj.put("slaOptions", slaOptionsObj);
        }
        return jsonObj;
    }

    @Override
    public void doAction() throws Exception {
        if (projectManager == null || executorManager == null) {
            throw new Exception("ExecuteFlowAction not properly initialized!");
        }
        Project project = FlowUtils.getProject(projectManager, this.projectId);
        Flow flow = FlowUtils.getFlow(project, this.flowName);
        ExecutableFlow exflow = FlowUtils.createExecutableFlow(project, flow);
        exflow.setSubmitUser(this.submitUser);
        if (this.executionOptions == null) {
            this.executionOptions = new ExecutionOptions();
        }
        if (!this.executionOptions.isFailureEmailsOverridden()) {
            this.executionOptions.setFailureEmails(flow.getFailureEmails());
        }
        if (!this.executionOptions.isSuccessEmailsOverridden()) {
            this.executionOptions.setSuccessEmails(flow.getSuccessEmails());
        }
        exflow.setExecutionOptions(this.executionOptions);
        if (this.slaOptions != null && this.slaOptions.size() > 0) {
            exflow.setSlaOptions(this.slaOptions);
        }
        try {
            logger.info((Object)("Invoking flow " + project.getName() + "." + this.flowName));
            executorManager.submitExecutableFlow(exflow, this.submitUser);
            logger.info((Object)("Invoked flow " + project.getName() + "." + this.flowName));
        }
        catch (ExecutorManagerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDescription() {
        return "Execute flow " + this.getFlowName() + " from project " + this.getProjectName();
    }

    @Override
    public void setContext(Map<String, Object> context) {
    }

    @Override
    public String getId() {
        return this.actionId;
    }

    static {
        logger = Logger.getLogger(ExecuteFlowAction.class);
    }
}

