/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.utils.EmailMessage;
import azkaban.utils.Props;
import java.util.Collection;

public class AbstractMailer {
    public static final int DEFAULT_SMTP_PORT = 25;
    private static final int MB_IN_BYTES = 0x100000;
    private final boolean usesAuth;
    private final String mailHost;
    private final int mailPort;
    private final String mailUser;
    private final String mailPassword;
    private final String mailSender;
    private final String azkabanName;
    private final String tls;
    private final long attachmentMazSizeInByte;

    public AbstractMailer(Props props) {
        this.azkabanName = props.getString("azkaban.name", "azkaban");
        this.mailHost = props.getString("mail.host", "localhost");
        this.mailPort = props.getInt("mail.port", 25);
        this.mailUser = props.getString("mail.user", "");
        this.mailPassword = props.getString("mail.password", "");
        this.tls = props.getString("mail.tls", "false");
        long maxAttachmentSizeInMB = props.getInt("mail.max.attachment.size.mb", 100);
        this.attachmentMazSizeInByte = maxAttachmentSizeInMB * 0x100000L;
        this.mailSender = props.getString("mail.sender", "");
        this.usesAuth = props.getBoolean("mail.useAuth", true);
    }

    protected EmailMessage createEmailMessage(String subject, String mimetype, Collection<String> emailList) {
        EmailMessage message = new EmailMessage(this.mailHost, this.mailPort, this.mailUser, this.mailPassword);
        message.setFromAddress(this.mailSender);
        message.addAllToAddress(emailList);
        message.setMimeType(mimetype);
        message.setSubject(subject);
        message.setAuth(this.usesAuth);
        message.setTLS(this.tls);
        return message;
    }

    public String getAzkabanName() {
        return this.azkabanName;
    }

    public long getAttachmentMaxSize() {
        return this.attachmentMazSizeInByte;
    }

    public boolean hasMailAuth() {
        return this.usesAuth;
    }
}

