/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.alert.Alerter;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.Status;
import azkaban.executor.mail.DefaultMailCreator;
import azkaban.executor.mail.MailCreator;
import azkaban.metrics.CommonMetrics;
import azkaban.sla.SlaOption;
import azkaban.utils.AbstractMailer;
import azkaban.utils.EmailMessage;
import azkaban.utils.Props;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@Singleton
public class Emailer
extends AbstractMailer
implements Alerter {
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static final Logger logger = Logger.getLogger(Emailer.class);
    private final CommonMetrics commonMetrics;
    private final String scheme;
    private final String clientHostname;
    private final String clientPortNumber;
    private final String mailHost;
    private final int mailPort;
    private final String mailUser;
    private final String mailPassword;
    private final String mailSender;
    private final String azkabanName;
    private final String tls;
    private final boolean testMode;

    @Inject
    public Emailer(Props props, CommonMetrics commonMetrics) {
        super(props);
        this.commonMetrics = Objects.requireNonNull(commonMetrics, "commonMetrics is null.");
        this.azkabanName = props.getString("azkaban.name", "azkaban");
        this.mailHost = props.getString("mail.host", "localhost");
        this.mailPort = props.getInt("mail.port", 25);
        this.mailUser = props.getString("mail.user", "");
        this.mailPassword = props.getString("mail.password", "");
        this.mailSender = props.getString("mail.sender", "");
        this.tls = props.getString("mail.tls", "false");
        int mailTimeout = props.getInt("mail.timeout.millis", 30000);
        EmailMessage.setTimeout(mailTimeout);
        int connectionTimeout = props.getInt("mail.connection.timeout.millis", 30000);
        EmailMessage.setConnectionTimeout(connectionTimeout);
        EmailMessage.setTotalAttachmentMaxSize(this.getAttachmentMaxSize());
        this.clientHostname = props.getString("azkaban.webserver.external_hostname", props.getString("jetty.hostname", "localhost"));
        if (props.getBoolean("jetty.use.ssl", true)) {
            this.scheme = HTTPS;
            this.clientPortNumber = Integer.toString(props.getInt("azkaban.webserver.external_ssl_port", props.getInt("jetty.ssl.port", 8443)));
        } else {
            this.scheme = HTTP;
            this.clientPortNumber = Integer.toString(props.getInt("azkaban.webserver.external_port", props.getInt("jetty.port", 8081)));
        }
        this.testMode = props.getBoolean("test.mode", false);
    }

    public static List<String> findFailedJobs(ExecutableFlow flow) {
        ArrayList<String> failedJobs = new ArrayList<String>();
        for (ExecutableNode node : flow.getExecutableNodes()) {
            if (node.getStatus() != Status.FAILED) continue;
            failedJobs.add(node.getId());
        }
        return failedJobs;
    }

    private void sendSlaAlertEmail(SlaOption slaOption, String slaMessage) {
        String subject = "SLA violation for " + this.getJobOrFlowName(slaOption) + " on " + this.getAzkabanName();
        List emailList = (List)slaOption.getInfo().get("EmailList");
        logger.info((Object)("Sending SLA email " + slaMessage));
        this.sendEmail(emailList, subject, slaMessage);
    }

    public void sendEmail(List<String> emailList, String subject, String body) {
        if (emailList != null && !emailList.isEmpty()) {
            EmailMessage message = super.createEmailMessage(subject, "text/html", emailList);
            message.setBody(body);
            if (!this.testMode) {
                try {
                    message.sendEmail();
                    logger.info((Object)("Sent email message " + body));
                    this.commonMetrics.markSendEmailSuccess();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to send email message " + body), (Throwable)e);
                    this.commonMetrics.markSendEmailFail();
                }
            }
        }
    }

    private String getJobOrFlowName(SlaOption slaOption) {
        String flowName = (String)slaOption.getInfo().get("FlowName");
        String jobName = (String)slaOption.getInfo().get("JobName");
        if (StringUtils.isNotBlank((String)jobName)) {
            return flowName + ":" + jobName;
        }
        return flowName;
    }

    public void sendFirstErrorMessage(ExecutableFlow flow) {
        EmailMessage message = new EmailMessage(this.mailHost, this.mailPort, this.mailUser, this.mailPassword);
        message.setFromAddress(this.mailSender);
        message.setTLS(this.tls);
        message.setAuth(super.hasMailAuth());
        ExecutionOptions option = flow.getExecutionOptions();
        MailCreator mailCreator = DefaultMailCreator.getCreator(option.getMailCreator());
        logger.debug((Object)("ExecutorMailer using mail creator:" + mailCreator.getClass().getCanonicalName()));
        boolean mailCreated = mailCreator.createFirstErrorMessage(flow, message, this.azkabanName, this.scheme, this.clientHostname, this.clientPortNumber, new String[0]);
        if (mailCreated && !this.testMode) {
            try {
                message.sendEmail();
                logger.info((Object)("Sent first error email message for execution " + flow.getExecutionId()));
                this.commonMetrics.markSendEmailSuccess();
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send first error email message for execution " + flow.getExecutionId()), (Throwable)e);
                this.commonMetrics.markSendEmailFail();
            }
        }
    }

    public void sendErrorEmail(ExecutableFlow flow, String ... extraReasons) {
        EmailMessage message = new EmailMessage(this.mailHost, this.mailPort, this.mailUser, this.mailPassword);
        message.setFromAddress(this.mailSender);
        message.setTLS(this.tls);
        message.setAuth(super.hasMailAuth());
        ExecutionOptions option = flow.getExecutionOptions();
        MailCreator mailCreator = DefaultMailCreator.getCreator(option.getMailCreator());
        logger.debug((Object)("ExecutorMailer using mail creator:" + mailCreator.getClass().getCanonicalName()));
        boolean mailCreated = mailCreator.createErrorEmail(flow, message, this.azkabanName, this.scheme, this.clientHostname, this.clientPortNumber, extraReasons);
        if (mailCreated && !this.testMode) {
            try {
                message.sendEmail();
                logger.info((Object)("Sent error email message for execution " + flow.getExecutionId()));
                this.commonMetrics.markSendEmailSuccess();
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send error email message for execution " + flow.getExecutionId()), (Throwable)e);
                this.commonMetrics.markSendEmailFail();
            }
        }
    }

    public void sendSuccessEmail(ExecutableFlow flow) {
        EmailMessage message = new EmailMessage(this.mailHost, this.mailPort, this.mailUser, this.mailPassword);
        message.setFromAddress(this.mailSender);
        message.setTLS(this.tls);
        message.setAuth(super.hasMailAuth());
        ExecutionOptions option = flow.getExecutionOptions();
        MailCreator mailCreator = DefaultMailCreator.getCreator(option.getMailCreator());
        logger.debug((Object)("ExecutorMailer using mail creator:" + mailCreator.getClass().getCanonicalName()));
        boolean mailCreated = mailCreator.createSuccessEmail(flow, message, this.azkabanName, this.scheme, this.clientHostname, this.clientPortNumber, new String[0]);
        if (mailCreated && !this.testMode) {
            try {
                message.sendEmail();
                logger.info((Object)("Sent success email message for execution " + flow.getExecutionId()));
                this.commonMetrics.markSendEmailSuccess();
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send success email message for execution " + flow.getExecutionId()), (Throwable)e);
                this.commonMetrics.markSendEmailFail();
            }
        }
    }

    @Override
    public void alertOnSuccess(ExecutableFlow exflow) {
        this.sendSuccessEmail(exflow);
    }

    @Override
    public void alertOnError(ExecutableFlow exflow, String ... extraReasons) {
        this.sendErrorEmail(exflow, extraReasons);
    }

    @Override
    public void alertOnFirstError(ExecutableFlow exflow) {
        this.sendFirstErrorMessage(exflow);
    }

    @Override
    public void alertOnSla(SlaOption slaOption, String slaMessage) {
        this.sendSlaAlertEmail(slaOption, slaMessage);
    }
}

