/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.utils.Props;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ExternalLinkUtils {
    private static final Logger logger = Logger.getLogger(ExternalLinkUtils.class);

    public static String getExternalAnalyzerOnReq(Props azkProps, HttpServletRequest req) {
        if (!azkProps.containsKey((Object)"azkaban.server.external.analyzer.topic")) {
            return "";
        }
        String topic = azkProps.getString("azkaban.server.external.analyzer.topic");
        return ExternalLinkUtils.getLinkFromRequest(topic, azkProps, req);
    }

    public static String getExternalLogViewer(Props azkProps, String jobId, Props jobProps) {
        if (!azkProps.containsKey((Object)"azkaban.server.external.logviewer.topic")) {
            return "";
        }
        String topic = azkProps.getString("azkaban.server.external.logviewer.topic");
        return ExternalLinkUtils.getLinkFromJobAndExecId(topic, azkProps, jobId, jobProps);
    }

    private static String getLinkFromJobAndExecId(String topic, Props azkProps, String jobId, Props jobProps) {
        String urlTemplate = ExternalLinkUtils.getURLForTopic(topic, azkProps);
        if (urlTemplate.isEmpty()) {
            logger.error((Object)("No URL specified for topic " + topic));
            return "";
        }
        String job = ExternalLinkUtils.encodeToUTF8(jobId);
        String execid = ExternalLinkUtils.encodeToUTF8(jobProps.getString("azkaban.flow.execid"));
        urlTemplate = urlTemplate.replace("${jobid}", job).replace("${execid}", execid);
        logger.info((Object)("Creating link: " + urlTemplate));
        return urlTemplate;
    }

    private static String getLinkFromRequest(String topic, Props azkProps, HttpServletRequest req) {
        String urlTemplate = ExternalLinkUtils.getURLForTopic(topic, azkProps);
        if (urlTemplate.isEmpty()) {
            logger.error((Object)("No URL specified for topic " + topic));
            return "";
        }
        String flowExecutionURL = "";
        flowExecutionURL = flowExecutionURL + req.getRequestURL();
        flowExecutionURL = flowExecutionURL + "?";
        flowExecutionURL = flowExecutionURL + req.getQueryString();
        flowExecutionURL = ExternalLinkUtils.encodeToUTF8(flowExecutionURL);
        urlTemplate = urlTemplate.replace("${url}", flowExecutionURL);
        logger.info((Object)("Creating link: " + urlTemplate));
        return urlTemplate;
    }

    static String getURLForTopic(String topic, Props azkProps) {
        return azkProps.getString("azkaban.server.external.${topic}.url".replace("${topic}", topic), "");
    }

    static String encodeToUTF8(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Specified encoding is not supported", (Throwable)e);
            return "";
        }
    }
}

