/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.utils.Pair;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;

public abstract class RestfulApiClient<T> {
    protected static Logger logger = Logger.getLogger(RestfulApiClient.class);

    public static URI buildUri(String host, int port, String path, boolean isHttp, Pair<String, String> ... params) throws IOException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(isHttp ? "http" : "https").setHost(host).setPort(port);
        if (null != path && path.length() > 0) {
            builder.setPath(path);
        }
        if (params != null) {
            for (Pair<String, String> pair : params) {
                builder.setParameter(pair.getFirst(), pair.getSecond());
            }
        }
        URI uri = null;
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return uri;
    }

    public static URI BuildUri(URI uri, Pair<String, String> ... params) throws IOException {
        URIBuilder builder = new URIBuilder(uri);
        if (params != null) {
            for (Pair<String, String> pair : params) {
                builder.setParameter(pair.getFirst(), pair.getSecond());
            }
        }
        URI returningUri = null;
        try {
            returningUri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return returningUri;
    }

    private static HttpMessage completeRequest(HttpMessage request, List<NameValuePair> headerEntries) {
        if (null == request) {
            logger.error((Object)"unable to complete request as the passed request object is null");
            return request;
        }
        if (null != headerEntries && headerEntries.size() > 0) {
            for (NameValuePair pair : headerEntries) {
                request.addHeader(pair.getName(), pair.getValue());
            }
        }
        return request;
    }

    private static HttpEntityEnclosingRequestBase completeRequest(HttpEntityEnclosingRequestBase request, List<NameValuePair> headerEntries, String postingBody) throws UnsupportedEncodingException {
        if (null != RestfulApiClient.completeRequest((HttpMessage)request, headerEntries) && null != postingBody && postingBody.length() > 0) {
            ByteArrayEntity entity = new ByteArrayEntity(postingBody.getBytes("UTF-8"));
            request.setHeader("Content-Length", Long.toString(entity.getContentLength()));
            request.setEntity((HttpEntity)entity);
        }
        return request;
    }

    protected abstract T parseResponse(HttpResponse var1) throws HttpResponseException, IOException;

    public T httpGet(URI uri, List<NameValuePair> headerEntries) throws IOException {
        if (null == uri) {
            logger.error((Object)" unable to perform httpGet as the passed uri is null");
            return null;
        }
        HttpGet get = new HttpGet(uri);
        return this.sendAndReturn((HttpUriRequest)((HttpGet)RestfulApiClient.completeRequest((HttpMessage)get, headerEntries)));
    }

    public T httpPost(URI uri, List<NameValuePair> headerEntries, String postingBody) throws UnsupportedEncodingException, IOException {
        if (null == uri) {
            logger.error((Object)" unable to perform httpPost as the passed uri is null.");
            return null;
        }
        HttpPost post = new HttpPost(uri);
        return this.sendAndReturn((HttpUriRequest)RestfulApiClient.completeRequest((HttpEntityEnclosingRequestBase)post, headerEntries, postingBody));
    }

    public T httpDelete(URI uri, List<NameValuePair> headerEntries) throws IOException {
        if (null == uri) {
            logger.error((Object)" unable to perform httpDelete as the passed uri is null.");
            return null;
        }
        HttpDelete delete = new HttpDelete(uri);
        return this.sendAndReturn((HttpUriRequest)((HttpDelete)RestfulApiClient.completeRequest((HttpMessage)delete, headerEntries)));
    }

    public T httpPut(URI uri, List<NameValuePair> headerEntries, String postingBody) throws UnsupportedEncodingException, IOException {
        if (null == uri) {
            logger.error((Object)" unable to perform httpPut as the passed url is null or empty.");
            return null;
        }
        HttpPut put = new HttpPut(uri);
        return this.sendAndReturn((HttpUriRequest)RestfulApiClient.completeRequest((HttpEntityEnclosingRequestBase)put, headerEntries, postingBody));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T sendAndReturn(HttpUriRequest request) throws IOException {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            T t = this.parseResponse((HttpResponse)client.execute(request));
            return t;
        }
    }
}

