/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class StringUtils {
    public static final char SINGLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    private static final Pattern BROWSWER_PATTERN = Pattern.compile(".*Gecko.*|.*AppleWebKit.*|.*Trident.*|.*Chrome.*");

    public static String shellQuote(String s, char quoteCh) {
        StringBuffer buf = new StringBuffer(s.length() + 2);
        buf.append(quoteCh);
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == quoteCh) {
                buf.append('\\');
            }
            buf.append(ch);
        }
        buf.append(quoteCh);
        return buf.toString();
    }

    @Deprecated
    public static String join(List<String> list, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        for (String str : list) {
            buffer.append(str);
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public static String join(Collection<String> list, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        for (String str : list) {
            buffer.append(str);
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public static String join2(Collection<String> list, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (String str : list) {
            if (!first) {
                buffer.append(delimiter);
            }
            buffer.append(str);
            first = false;
        }
        return buffer.toString();
    }

    public static boolean isFromBrowser(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        return BROWSWER_PATTERN.matcher(userAgent).matches();
    }
}

