/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.executor.Status;
import java.text.NumberFormat;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;

public class WebUtils {
    public static final String DATE_TIME_STRING = "YYYY-MM-dd HH:mm:ss";
    public static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private static final long ONE_KB = 1024L;
    private static final long ONE_MB = 0x100000L;
    private static final long ONE_GB = 0x40000000L;
    private static final long ONE_TB = 0x10000000000L;

    public String formatDate(long timeMS) {
        if (timeMS == -1L) {
            return "-";
        }
        return DateTimeFormat.forPattern((String)DATE_TIME_STRING).print(timeMS);
    }

    public long currentTimestamp() {
        return System.currentTimeMillis();
    }

    public String formatDuration(long startTime, long endTime) {
        if (startTime == -1L) {
            return "-";
        }
        long durationMS = endTime == -1L ? System.currentTimeMillis() - startTime : endTime - startTime;
        long seconds = durationMS / 1000L;
        if (seconds < 60L) {
            return seconds + " sec";
        }
        long minutes = seconds / 60L;
        seconds %= 60L;
        if (minutes < 60L) {
            return minutes + "m " + seconds + "s";
        }
        long hours = minutes / 60L;
        minutes %= 60L;
        if (hours < 24L) {
            return hours + "h " + minutes + "m " + seconds + "s";
        }
        long days = hours / 24L;
        return days + "d " + (hours %= 24L) + "h " + minutes + "m";
    }

    public String formatStatus(Status status) {
        switch (status) {
            case SUCCEEDED: {
                return "Success";
            }
            case FAILED: {
                return "Failed";
            }
            case RUNNING: {
                return "Running";
            }
            case DISABLED: {
                return "Disabled";
            }
            case KILLED: {
                return "Killed";
            }
            case FAILED_FINISHING: {
                return "Running w/Failure";
            }
            case PREPARING: {
                return "Preparing";
            }
            case READY: {
                return "Ready";
            }
            case PAUSED: {
                return "Paused";
            }
            case SKIPPED: {
                return "Skipped";
            }
            case KILLING: {
                return "Killing";
            }
        }
        return "Unknown";
    }

    public String formatDateTime(DateTime dt) {
        return DateTimeFormat.forPattern((String)DATE_TIME_STRING).print((ReadableInstant)dt);
    }

    public String formatDateTime(long timestamp) {
        return this.formatDateTime(new DateTime(timestamp));
    }

    public String formatPeriod(ReadablePeriod period) {
        String periodStr = "null";
        if (period == null) {
            return periodStr;
        }
        if (period.get(DurationFieldType.years()) > 0) {
            int years = period.get(DurationFieldType.years());
            periodStr = years + " year(s)";
        } else if (period.get(DurationFieldType.months()) > 0) {
            int months = period.get(DurationFieldType.months());
            periodStr = months + " month(s)";
        } else if (period.get(DurationFieldType.weeks()) > 0) {
            int weeks = period.get(DurationFieldType.weeks());
            periodStr = weeks + " week(s)";
        } else if (period.get(DurationFieldType.days()) > 0) {
            int days = period.get(DurationFieldType.days());
            periodStr = days + " day(s)";
        } else if (period.get(DurationFieldType.hours()) > 0) {
            int hours = period.get(DurationFieldType.hours());
            periodStr = hours + " hour(s)";
        } else if (period.get(DurationFieldType.minutes()) > 0) {
            int minutes = period.get(DurationFieldType.minutes());
            periodStr = minutes + " minute(s)";
        } else if (period.get(DurationFieldType.seconds()) > 0) {
            int seconds = period.get(DurationFieldType.seconds());
            periodStr = seconds + " second(s)";
        }
        return periodStr;
    }

    public String extractNumericalId(String execId) {
        int index = execId.indexOf(46);
        int index2 = execId.indexOf(46, index + 1);
        return execId.substring(0, index2);
    }

    public String displayBytes(long sizeBytes) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        if (sizeBytes >= 0x10000000000L) {
            return nf.format((double)sizeBytes / 1.099511627776E12) + " tb";
        }
        if (sizeBytes >= 0x40000000L) {
            return nf.format((double)sizeBytes / 1.073741824E9) + " gb";
        }
        if (sizeBytes >= 0x100000L) {
            return nf.format((double)sizeBytes / 1048576.0) + " mb";
        }
        if (sizeBytes >= 1024L) {
            return nf.format((double)sizeBytes / 1024.0) + " kb";
        }
        return sizeBytes + " B";
    }

    public String getRealClientIpAddr(Map<String, String> httpHeaders, String remoteAddr) {
        String clientIp = httpHeaders.getOrDefault(X_FORWARDED_FOR_HEADER, null);
        if (clientIp == null) {
            clientIp = remoteAddr;
        } else {
            String[] ips = clientIp.split(",");
            clientIp = ips[0];
        }
        String[] parts = clientIp.split(":");
        clientIp = parts[0];
        return clientIp;
    }
}

